/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.mappingio.FlatMappingVisitor;
import net.fabricmc.mappingio.format.FeatureSet;
import net.fabricmc.mappingio.format.FeatureSetBuilder;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class SubsetChecker
implements FlatMappingVisitor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final MappingTreeView supTree;
    private final int supDstNsCount;
    private final MappingFormat subFormat;
    private final FeatureSet supFeatures;
    private final FeatureSet subFeatures;
    private final Consumer<String> errorHandler;
    private final Set<String> visitedIncomingParentElements = new HashSet<String>();
    private int subNsIfSupNotNamespaced;
    private List<String> subDstNamespaces;

    public SubsetChecker(MappingTreeView supTree, @Nullable MappingFormat supFormat, @Nullable MappingFormat subFormat, Consumer<String> errorHandler) {
        this.supTree = supTree;
        this.subFormat = subFormat;
        this.supDstNsCount = supTree.getMaxNamespaceId();
        this.supFeatures = supFormat == null ? new FeatureSetBuilder(true).build() : supFormat.features();
        this.subFeatures = subFormat == null ? new FeatureSetBuilder(true).build() : subFormat.features();
        this.errorHandler = errorHandler;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        String expectedSrcNs = this.subFeatures.hasNamespaces() && this.supFeatures.hasNamespaces() ? this.supTree.getSrcNamespace() : srcNamespace;
        this.assertEquals(expectedSrcNs, srcNamespace, "Incoming mappings have different source namespace than supTree");
        this.subDstNamespaces = new ArrayList<String>(dstNamespaces);
        if (!this.subFeatures.hasNamespaces()) {
            this.assertEquals(1, dstNamespaces.size(), "Incoming mappings have multiple namespaces (" + String.join((CharSequence)", ", dstNamespaces) + ") despite their supposed originating format (" + (Object)((Object)this.subFormat) + ") declaring not to support them");
            this.assertEquals("target", dstNamespaces.get(0), "Incoming mappings don't have default destination namespace name of non-namespaced formats");
            this.subDstNamespaces.set(0, this.supTree.getNamespaceName(0));
            return;
        }
        for (int i15 = 0; i15 < dstNamespaces.size(); ++i15) {
            String dstNs = dstNamespaces.get(i15);
            boolean contained = this.supTree.getDstNamespaces().contains(dstNs);
            if (!this.supFeatures.hasNamespaces()) {
                if (contained) {
                    this.subNsIfSupNotNamespaced = i15;
                    break;
                }
                if (i15 < dstNamespaces.size() - 1) continue;
                if (this.supTree.getNamespaceName(0).equals("target")) {
                    this.subNsIfSupNotNamespaced = 0;
                    this.subDstNamespaces.set(0, this.supTree.getNamespaceName(0));
                    break;
                }
            }
            this.assertTrue(contained, "Incoming namespace not contained in supTree: " + dstNs);
        }
    }

    @Override
    public boolean visitClass(String srcName, @Nullable String[] dstNames) throws IOException {
        if (!this.supFeatures.supportsClasses()) {
            return true;
        }
        MappingTreeView.ClassMappingView supCls = this.supTree.getClass(srcName);
        this.visitedIncomingParentElements.add(srcName);
        boolean supHasDstNames = this.supFeatures.classes().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasDstNames = this.subFeatures.classes().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasRepackaging = this.supFeatures.classes().hasRepackaging();
        boolean subHasRepackaging = this.subFeatures.classes().hasRepackaging();
        if (supCls == null) {
            if (supHasDstNames && subHasDstNames) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstNames == null) {
                    stringArray = dstNames;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = dstNames[this.subNsIfSupNotNamespaced];
                }
                String[] subDstNames = stringArray;
                if (!this.isNullOrEmpty(subDstNames)) {
                    boolean error = true;
                    if (!supHasRepackaging) {
                        for (String subDstName : subDstNames) {
                            if (subDstName == null) continue;
                            String srcPkg = this.getPackage(srcName);
                            String dstPkg = this.getPackage(subDstName);
                            if (srcPkg != null && srcPkg.equals(dstPkg)) {
                                error = true;
                                break;
                            }
                            error = false;
                        }
                    }
                    this.assertFalse(error, "Incoming class not contained in supTree: " + srcName);
                }
            }
            return true;
        }
        HashMap<String, String> supDstNamesByNsName = new HashMap<String, String>();
        for (int supNs = 0; supNs < this.supDstNsCount; ++supNs) {
            supDstNamesByNsName.put(this.supTree.getNamespaceName(supNs), supCls.getDstName(supNs));
        }
        if (supHasDstNames && subHasDstNames && dstNames != null) {
            for (int subNs = 0; subNs < this.subDstNamespaces.size(); ++subNs) {
                boolean error;
                String subDstName;
                String supDstName = (String)supDstNamesByNsName.get(this.subDstNamespaces.get(subNs));
                if (supDstName == null && !this.supFeatures.hasNamespaces() || (subDstName = dstNames[subNs]) == null && (supDstName == null || Objects.equals(supDstName, srcName))) continue;
                if (supDstName == null) {
                    supDstName = srcName;
                }
                boolean bl4 = error = !Objects.equals(supDstName, subDstName);
                if (error && subDstName == null && !subHasRepackaging && supHasRepackaging) {
                    String srcPkg = this.getPackage(srcName);
                    String dstPkg = this.getPackage(supDstName);
                    if (srcPkg != null && srcPkg.equals(dstPkg)) {
                        error = false;
                    }
                }
                if (!error) continue;
                this.assertEquals(supDstName, subDstName, "Incoming class destination name differs from supTree");
            }
        }
        return true;
    }

    @Override
    public void visitClassComment(String srcName, @Nullable String[] dstNames, String comment) throws IOException {
        if (!this.supFeatures.supportsClasses() || this.supFeatures.elementComments() == FeatureSet.ElementCommentSupport.NONE) {
            return;
        }
        MappingTreeView.ClassMappingView supCls = this.requireNonNull(this.supTree.getClass(srcName), "Incoming class comment's parent class not contained in supTree: " + srcName);
        this.assertEquals(supCls.getComment(), comment, "Incoming class comment not contained in supTree: " + srcName);
    }

    @Override
    public boolean visitField(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String[] dstClsNames, @Nullable String[] dstNames, @Nullable String[] dstDescs) throws IOException {
        boolean supRequiresDstDescs;
        if (!this.supFeatures.supportsFields()) {
            return true;
        }
        String subFldId = srcClsName + "#" + srcName + ":" + srcDesc;
        MappingTreeView.ClassMappingView supCls = this.getVisitedSupCls(srcClsName, "Incoming field's parent class not contained in supTree: " + subFldId);
        MappingTreeView.FieldMappingView supFld = supCls == null ? null : supCls.getField(srcName, srcDesc);
        boolean supHasSrcDescs = this.supFeatures.fields().srcDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasSrcDescs = this.subFeatures.fields().srcDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstNames = this.supFeatures.fields().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasDstNames = this.subFeatures.fields().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstDescs = this.supFeatures.fields().dstDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasDstDescs = this.subFeatures.fields().dstDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean supRequiresDstNames = this.supFeatures.fields().dstNames() == FeatureSet.FeaturePresence.REQUIRED;
        boolean supRequiresSrcDescs = this.supFeatures.fields().srcDescs() == FeatureSet.FeaturePresence.REQUIRED;
        boolean bl4 = supRequiresDstDescs = this.supFeatures.fields().dstDescs() == FeatureSet.FeaturePresence.REQUIRED;
        if (supFld == null) {
            String[] subDstNames = EMPTY_STRING_ARRAY;
            String[] subDstDescs = EMPTY_STRING_ARRAY;
            if (supHasDstNames && subHasDstNames) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstNames == null) {
                    stringArray = this.nullToEmpty(dstNames);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = dstNames[this.subNsIfSupNotNamespaced];
                }
                subDstNames = stringArray;
            }
            if (supHasDstDescs && subHasDstDescs) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstDescs == null) {
                    stringArray = this.nullToEmpty(dstDescs);
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = dstDescs[this.subNsIfSupNotNamespaced];
                }
                subDstDescs = stringArray;
            }
            boolean hasDstData = !this.isEmpty(subDstNames) || !this.isEmpty(subDstDescs);
            boolean missingRequiredSrcDesc = supRequiresSrcDescs && srcDesc == null;
            boolean missingRequiredDstName = false;
            boolean missingRequiredDstDesc = false;
            if (hasDstData && (supRequiresDstNames || supRequiresDstDescs)) {
                int subDstNsCount = subDstNames != null ? subDstNames.length : subDstDescs.length;
                for (int subDstNs = 0; subDstNs < subDstNsCount; ++subDstNs) {
                    String subDstDesc;
                    String subDstName = subDstNames == EMPTY_STRING_ARRAY ? null : subDstNames[subDstNs];
                    String string = subDstDesc = subDstDescs == EMPTY_STRING_ARRAY ? null : subDstDescs[subDstNs];
                    if (supRequiresDstNames && !missingRequiredDstName && subDstName == null) {
                        missingRequiredDstName = true;
                        if (missingRequiredDstDesc) break;
                    }
                    if (!supRequiresDstDescs || missingRequiredDstDesc || subDstDesc != null) continue;
                    missingRequiredDstDesc = true;
                    if (missingRequiredDstName) break;
                }
            }
            this.assertTrue(!hasDstData || missingRequiredSrcDesc || missingRequiredDstName || missingRequiredDstDesc, "Incoming field not contained in supTree: " + subFldId);
            return !missingRequiredSrcDesc && !missingRequiredDstName && !missingRequiredDstDesc;
        }
        String supFldId = srcClsName + "#" + srcName + ":" + supFld.getSrcDesc();
        HashMap<String, String[]> supDstDataByNsName = new HashMap<String, String[]>();
        for (int supNs = 0; supNs < this.supDstNsCount; ++supNs) {
            supDstDataByNsName.put(this.supTree.getNamespaceName(supNs), new String[]{supFld.getDstName(supNs), supFld.getDstDesc(supNs)});
        }
        for (int subNs = 0; subNs < this.subDstNamespaces.size(); ++subNs) {
            boolean uncompletedDst;
            String[] supDstData;
            if (supHasSrcDescs && subHasSrcDescs && srcDesc != null) {
                this.assertEquals(supFldId, subFldId, "Incoming field source descriptor differs from supTree");
            }
            if ((supDstData = (String[])supDstDataByNsName.get(this.subDstNamespaces.get(subNs))) == null && !this.supFeatures.hasNamespaces()) continue;
            if (supHasDstNames && subHasDstNames && dstNames != null) {
                String supDstName = supDstData[0];
                String subDstName = dstNames[subNs];
                boolean bl5 = uncompletedDst = subDstName == null && (supDstName == null || Objects.equals(supDstName, srcName));
                if (!uncompletedDst) {
                    this.assertEquals(supDstName != null ? supDstName : srcName, subDstName, "Incoming field (" + subFldId + ") destination name differs from supTree");
                }
            }
            if (!supHasDstDescs || !subHasDstDescs || dstDescs == null) continue;
            String supDstDesc = supDstData[1];
            String subDstDesc = dstDescs[subNs];
            boolean bl6 = uncompletedDst = subDstDesc == null && (supDstDesc == null || Objects.equals(supDstDesc, srcDesc));
            if (uncompletedDst) continue;
            String subFldDestId = srcClsName + "#" + srcName + ":" + subDstDesc;
            String supFldDestId = srcClsName + "#" + srcName + ":" + (supDstDesc != null ? supDstDesc : srcDesc);
            this.assertEquals(supFldDestId, subFldDestId, "Incoming field destination descriptor differs from supTree");
        }
        return true;
    }

    @Override
    public void visitFieldComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String[] dstClsNames, @Nullable String[] dstNames, @Nullable String[] dstDescs, String comment) throws IOException {
        if (!this.supFeatures.supportsFields() || this.supFeatures.elementComments() == FeatureSet.ElementCommentSupport.NONE) {
            return;
        }
        String subFldId = srcClsName + "#" + srcName + ":" + srcDesc;
        MappingTreeView.ClassMappingView supCls = this.requireNonNull(this.supTree.getClass(srcClsName), "Incoming field comment's parent class not contained in supTree: " + subFldId);
        MappingTreeView.FieldMappingView supFld = this.requireNonNull(supCls.getField(srcName, srcDesc), "Incoming field comment's parent field not contained in supTree: " + subFldId);
        this.assertEquals(supFld.getComment(), comment, "Incoming comment differs from supTree");
    }

    @Override
    public boolean visitMethod(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String[] dstClsNames, @Nullable String[] dstNames, @Nullable String[] dstDescs) throws IOException {
        boolean supRequiresDstDescs;
        if (!this.supFeatures.supportsMethods()) {
            return true;
        }
        String subMthId = srcClsName + "#" + srcName + srcDesc;
        MappingTreeView.ClassMappingView supCls = this.getVisitedSupCls(srcClsName, "Incoming method's parent class not contained in supTree: " + subMthId);
        MappingTreeView.MethodMappingView supMth = supCls == null ? null : supCls.getMethod(srcName, srcDesc);
        this.visitedIncomingParentElements.add(subMthId);
        boolean supHasSrcDescs = this.supFeatures.methods().srcDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasSrcDescs = this.subFeatures.methods().srcDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstNames = this.supFeatures.methods().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasDstNames = this.subFeatures.methods().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstDescs = this.supFeatures.methods().dstDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasDstDescs = this.subFeatures.methods().dstDescs() != FeatureSet.FeaturePresence.ABSENT;
        boolean supRequiresDstNames = this.supFeatures.methods().dstNames() == FeatureSet.FeaturePresence.REQUIRED;
        boolean supRequiresSrcDescs = this.supFeatures.methods().srcDescs() == FeatureSet.FeaturePresence.REQUIRED;
        boolean bl4 = supRequiresDstDescs = this.supFeatures.methods().dstDescs() == FeatureSet.FeaturePresence.REQUIRED;
        if (supMth == null) {
            String[] subDstNames = EMPTY_STRING_ARRAY;
            String[] subDstDescs = EMPTY_STRING_ARRAY;
            if (supHasDstNames && subHasDstNames) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstNames == null) {
                    stringArray = this.nullToEmpty(dstNames);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = dstNames[this.subNsIfSupNotNamespaced];
                }
                subDstNames = stringArray;
            }
            if (supHasDstDescs && subHasDstDescs) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstDescs == null) {
                    stringArray = this.nullToEmpty(dstDescs);
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = dstDescs[this.subNsIfSupNotNamespaced];
                }
                subDstDescs = stringArray;
            }
            boolean hasDstData = !this.isEmpty(subDstNames) || !this.isEmpty(subDstDescs);
            boolean missingRequiredSrcDesc = supRequiresSrcDescs && srcDesc == null;
            boolean missingRequiredDstName = false;
            boolean missingRequiredDstDesc = false;
            if (hasDstData && (supRequiresDstNames || supRequiresDstDescs)) {
                int subDstNsCount = subDstNames != null ? subDstNames.length : subDstDescs.length;
                for (int subDstNs = 0; subDstNs < subDstNsCount; ++subDstNs) {
                    String subDstDesc;
                    String subDstName = subDstNames == EMPTY_STRING_ARRAY ? null : subDstNames[subDstNs];
                    String string = subDstDesc = subDstDescs == EMPTY_STRING_ARRAY ? null : subDstDescs[subDstNs];
                    if (supRequiresDstNames && !missingRequiredDstName && subDstName == null) {
                        missingRequiredDstName = true;
                        if (missingRequiredDstDesc) break;
                    }
                    if (!supRequiresDstDescs || missingRequiredDstDesc || subDstDesc != null) continue;
                    missingRequiredDstDesc = true;
                    if (missingRequiredDstName) break;
                }
            }
            this.assertTrue(!hasDstData || missingRequiredSrcDesc || missingRequiredDstName || missingRequiredDstDesc, "Incoming method not contained in supTree: " + subMthId);
            return !missingRequiredSrcDesc && !missingRequiredDstName && !missingRequiredDstDesc;
        }
        String supMthId = srcClsName + "#" + srcName + supMth.getSrcDesc();
        HashMap<String, String[]> supDstDataByNsName = new HashMap<String, String[]>();
        for (int supNs = 0; supNs < this.supDstNsCount; ++supNs) {
            supDstDataByNsName.put(this.supTree.getNamespaceName(supNs), new String[]{supMth.getDstName(supNs), supMth.getDstDesc(supNs)});
        }
        for (int subNs = 0; subNs < this.subDstNamespaces.size(); ++subNs) {
            boolean uncompletedDst;
            String[] supDstData;
            if (supHasSrcDescs && subHasSrcDescs && srcDesc != null) {
                this.assertEquals(supMthId, subMthId, "Incoming method source descriptor differs from supTree");
            }
            if ((supDstData = (String[])supDstDataByNsName.get(this.subDstNamespaces.get(subNs))) == null && !this.supFeatures.hasNamespaces()) continue;
            if (supHasDstNames && subHasDstNames && dstNames != null) {
                String supDstName = supDstData[0];
                String subDstName = dstNames[subNs];
                boolean bl5 = uncompletedDst = subDstName == null && (supDstName == null || Objects.equals(supDstName, srcName));
                if (!uncompletedDst) {
                    this.assertEquals(supDstName != null ? supDstName : srcName, subDstName, "Incoming method (" + subMthId + ") destination name differs from supTree");
                }
            }
            if (!supHasDstDescs || !subHasDstDescs || dstDescs == null) continue;
            String supDstDesc = supDstData[1];
            String subDstDesc = dstDescs[subNs];
            boolean bl6 = uncompletedDst = subDstDesc == null && (supDstDesc == null || Objects.equals(supDstDesc, srcDesc));
            if (uncompletedDst) continue;
            String subMthDestId = srcClsName + "#" + srcName + subDstDesc;
            String supMthDestId = srcClsName + "#" + srcName + (supDstDesc != null ? supDstDesc : srcDesc);
            this.assertEquals(supMthDestId, subMthDestId, "Incoming method destination descriptor differs from supTree");
        }
        return true;
    }

    @Override
    public void visitMethodComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String[] dstClsNames, @Nullable String[] dstNames, @Nullable String[] dstDescs, String comment) throws IOException {
        if (!this.supFeatures.supportsMethods() || this.supFeatures.elementComments() == FeatureSet.ElementCommentSupport.NONE) {
            return;
        }
        String subMthId = srcClsName + "#" + srcName + srcDesc;
        MappingTreeView.ClassMappingView supCls = this.requireNonNull(this.supTree.getClass(srcClsName), "Incoming method comment's parent class not contained in supTree: " + subMthId);
        MappingTreeView.MethodMappingView supMth = this.requireNonNull(supCls.getMethod(srcName, srcDesc), "Incoming method comment's parent method not contained in supTree: " + subMthId);
        this.assertEquals(supMth.getComment(), comment, "Incoming comment differs from supTree");
    }

    @Override
    public boolean visitMethodArg(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, @Nullable String[] dstClsNames, @Nullable String[] dstMethodNames, @Nullable String[] dstMethodDescs, @Nullable String[] dstNames) throws IOException {
        boolean subHasDstNames;
        if (!this.supFeatures.supportsArgs()) {
            return true;
        }
        String subArgId = srcClsName + "#" + srcMethodName + srcMethodDesc + ":" + argPosition + ":" + lvIndex + ":" + srcName;
        MappingTreeView.ClassMappingView supCls = this.getVisitedSupCls(srcClsName, "Incoming arg's parent class not contained in supTree: " + subArgId);
        MappingTreeView.MethodMappingView supMth = supCls == null ? null : this.getVisitedSupMth(supCls, srcMethodName, srcMethodDesc, "Incoming arg's parent method not contained in supTree: " + subArgId);
        MappingTreeView.MethodArgMappingView supArg = supMth == null ? null : supMth.getArg(argPosition, lvIndex, srcName);
        boolean supHasPositions = this.supFeatures.args().positions() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasPositions = this.subFeatures.args().positions() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasLvIndices = this.supFeatures.args().lvIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasLvIndices = this.subFeatures.args().lvIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasSrcNames = this.supFeatures.args().srcNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasSrcNames = this.subFeatures.args().srcNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstNames = this.supFeatures.args().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean bl4 = subHasDstNames = this.subFeatures.args().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        if (supArg == null) {
            if (supHasDstNames && subHasDstNames) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstNames == null) {
                    stringArray = dstNames;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = dstNames[this.subNsIfSupNotNamespaced];
                }
                String[] subDstNames = stringArray;
                this.assertTrue(this.isNullOrEmpty(subDstNames), "Incoming arg not contained in supTree: " + subArgId);
            }
            return true;
        }
        HashMap<String, String> supDstNamesByNsName = new HashMap<String, String>();
        for (int supNs = 0; supNs < this.supDstNsCount; ++supNs) {
            supDstNamesByNsName.put(this.supTree.getNamespaceName(supNs), supArg.getDstName(supNs));
        }
        for (int subNs = 0; subNs < this.subDstNamespaces.size(); ++subNs) {
            boolean uncompletedDst;
            if (supHasPositions && subHasPositions) {
                this.assertEquals(supArg.getArgPosition(), argPosition, "Incoming arg (" + subArgId + ") argPosition differs from supTree");
            }
            if (supHasLvIndices && subHasLvIndices) {
                this.assertEquals(supArg.getLvIndex(), lvIndex, "Incoming arg (" + subArgId + ") lvIndex differs from supTree");
            }
            if (supHasSrcNames && subHasSrcNames) {
                this.assertEquals(supArg.getSrcName(), srcName, "Incoming arg (" + subArgId + ") srcName differs from supTree");
            }
            if (!supHasDstNames || !subHasDstNames || dstNames == null) continue;
            String supDstName = (String)supDstNamesByNsName.get(this.subDstNamespaces.get(subNs));
            String subDstName = dstNames[subNs];
            boolean bl5 = uncompletedDst = subDstName == null && (supDstName == null || Objects.equals(supDstName, srcName));
            if (uncompletedDst) continue;
            this.assertEquals(supDstName != null ? supDstName : srcName, subDstName, "Incoming arg (" + subArgId + ") destination name differs from supTree");
        }
        return true;
    }

    @Override
    public void visitMethodArgComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcArgName, @Nullable String[] dstClsNames, @Nullable String[] dstMethodNames, @Nullable String[] dstMethodDescs, @Nullable String[] dstNames, String comment) throws IOException {
        if (!this.supFeatures.supportsArgs() || this.supFeatures.elementComments() == FeatureSet.ElementCommentSupport.NONE) {
            return;
        }
        String subArgId = srcClsName + "#" + srcMethodName + srcMethodDesc + ":" + argPosition + ":" + lvIndex + ":" + srcArgName;
        MappingTreeView.ClassMappingView supCls = this.requireNonNull(this.supTree.getClass(srcClsName), "Incoming arg comment's parent class not contained in supTree: " + subArgId);
        MappingTreeView.MethodMappingView supMth = this.requireNonNull(supCls.getMethod(srcMethodName, srcMethodDesc), "Incoming arg comment's parent method not contained in supTree: " + subArgId);
        MappingTreeView.MethodArgMappingView supArg = this.requireNonNull(supMth.getArg(argPosition, lvIndex, srcArgName), "Incoming arg comment's parent arg not contained in supTree: " + subArgId);
        this.assertEquals(supArg.getComment(), comment, "Incoming comment differs from supTree");
    }

    @Override
    public boolean visitMethodVar(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, @Nullable String[] dstClsNames, @Nullable String[] dstMethodNames, @Nullable String[] dstMethodDescs, @Nullable String[] dstNames) throws IOException {
        boolean subHasDstNames;
        if (!this.supFeatures.supportsVars()) {
            return true;
        }
        String subVarId = srcClsName + "#" + srcMethodName + srcMethodDesc + ":" + lvtRowIndex + ":" + lvIndex + ":" + startOpIdx + ":" + endOpIdx + ":" + srcName;
        MappingTreeView.ClassMappingView supCls = this.getVisitedSupCls(srcClsName, "Incoming var's parent class not contained in supTree: " + subVarId);
        MappingTreeView.MethodMappingView supMth = supCls == null ? null : this.getVisitedSupMth(supCls, srcMethodName, srcMethodDesc, "Incoming var's parent method not contained in supTree: " + subVarId);
        MappingTreeView.MethodVarMappingView supVar = supMth == null ? null : supMth.getVar(lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName);
        boolean supHasLvIndices = this.supFeatures.vars().lvIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasLvIndices = this.subFeatures.vars().lvIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasLvtIndices = this.supFeatures.vars().lvtRowIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasLvtIndices = this.subFeatures.vars().lvtRowIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasStartOpIndices = this.supFeatures.vars().startOpIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasStartOpIndices = this.subFeatures.vars().startOpIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasEndOpIndices = this.supFeatures.vars().endOpIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasEndOpIndices = this.subFeatures.vars().endOpIndices() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasSrcNames = this.supFeatures.vars().srcNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean subHasSrcNames = this.subFeatures.vars().srcNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean supHasDstNames = this.supFeatures.vars().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        boolean bl4 = subHasDstNames = this.subFeatures.vars().dstNames() != FeatureSet.FeaturePresence.ABSENT;
        if (supVar == null) {
            if (supHasDstNames && subHasDstNames) {
                String[] stringArray;
                if (this.supFeatures.hasNamespaces() || dstNames == null) {
                    stringArray = dstNames;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = dstNames[this.subNsIfSupNotNamespaced];
                }
                String[] subDstNames = stringArray;
                this.assertTrue(this.isNullOrEmpty(subDstNames), "Incoming var not contained in supTree: " + subVarId);
            }
            return true;
        }
        HashMap<String, String> supDstNamesByNsName = new HashMap<String, String>();
        for (int supNs = 0; supNs < this.supDstNsCount; ++supNs) {
            supDstNamesByNsName.put(this.supTree.getNamespaceName(supNs), supVar.getDstName(supNs));
        }
        for (int subNs = 0; subNs < this.subDstNamespaces.size(); ++subNs) {
            boolean uncompletedDst;
            if (supHasLvIndices && subHasLvIndices) {
                this.assertEquals(supVar.getLvIndex(), lvIndex, "Incoming var (" + subVarId + ") lvIndex differs from supTree");
            }
            if (supHasLvtIndices && subHasLvtIndices) {
                this.assertEquals(supVar.getLvtRowIndex(), lvtRowIndex, "Incoming var (" + subVarId + ") lvtRowIndex differs from supTree");
            }
            if (supHasStartOpIndices && subHasStartOpIndices) {
                this.assertEquals(supVar.getStartOpIdx(), startOpIdx, "Incoming var (" + subVarId + ") startOpIndex differs from supTree");
            }
            if (supHasEndOpIndices && subHasEndOpIndices) {
                this.assertEquals(supVar.getEndOpIdx(), endOpIdx, "Incoming var (" + subVarId + ") endOpIndex differs from supTree");
            }
            if (supHasSrcNames && subHasSrcNames) {
                this.assertEquals(supVar.getSrcName(), srcName, "Incoming var (" + subVarId + ") srcName differs from supTree");
            }
            if (!supHasDstNames || !subHasDstNames || dstNames == null) continue;
            String supDstName = (String)supDstNamesByNsName.get(this.subDstNamespaces.get(subNs));
            String subDstName = dstNames[subNs];
            boolean bl5 = uncompletedDst = subDstName == null && (supDstName == null || Objects.equals(supDstName, srcName));
            if (uncompletedDst) continue;
            this.assertEquals(supDstName != null ? supDstName : srcName, subDstName, "Incoming var (" + subVarId + ") destination name differs from supTree");
        }
        return true;
    }

    @Override
    public void visitMethodVarComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcVarName, @Nullable String[] dstClsNames, @Nullable String[] dstMethodNames, @Nullable String[] dstMethodDescs, @Nullable String[] dstNames, String comment) throws IOException {
        if (!this.supFeatures.supportsVars() || this.supFeatures.elementComments() == FeatureSet.ElementCommentSupport.NONE) {
            return;
        }
        String subVarId = srcClsName + "#" + srcMethodName + srcMethodDesc + ":" + lvtRowIndex + ":" + lvIndex + ":" + startOpIdx + ":" + endOpIdx + ":" + srcVarName;
        MappingTreeView.ClassMappingView supCls = this.requireNonNull(this.supTree.getClass(srcClsName), "Incoming var comment's parent class not contained in supTree: " + subVarId);
        MappingTreeView.MethodMappingView supMth = this.requireNonNull(supCls.getMethod(srcMethodName, srcMethodDesc), "Incoming var comment's parent method not contained in supTree: " + subVarId);
        MappingTreeView.MethodVarMappingView supVar = this.requireNonNull(supMth.getVar(lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcVarName), "Incoming var comment's parent var not contained in supTree: " + subVarId);
        this.assertEquals(supVar.getComment(), comment, "Incoming comment differs from supTree");
    }

    protected void assertTrue(boolean condition2, String message2) {
        if (!condition2) {
            this.errorHandler.accept(message2);
        }
    }

    protected void assertFalse(boolean condition2, String message2) {
        if (condition2) {
            this.errorHandler.accept(message2);
        }
    }

    protected void assertEquals(Object expected, Object actual, String message2) {
        if (!Objects.equals(expected, actual)) {
            this.errorHandler.accept(message2 + ": Expected: " + expected + ", Actual: " + actual);
        }
    }

    protected void assertNotNull(Object obj, String message2) {
        if (obj == null) {
            this.errorHandler.accept(message2);
        }
    }

    private <T> T requireNonNull(T obj, String message2) {
        this.assertNotNull(obj, message2);
        return obj;
    }

    private String[] nullToEmpty(String[] arr) {
        return arr != null ? arr : EMPTY_STRING_ARRAY;
    }

    private boolean isNullOrEmpty(String[] arr) {
        return arr == null || this.isEmpty(arr);
    }

    private boolean isEmpty(String[] arr) {
        for (String s15 : arr) {
            if (s15 == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private String getPackage(String name) {
        int lastSlash = name.lastIndexOf(47);
        return lastSlash == -1 ? null : name.substring(0, lastSlash);
    }

    @Nullable
    private MappingTreeView.ClassMappingView getVisitedSupCls(String clsSrcName, String notFoundMessage) {
        MappingTreeView.ClassMappingView supCls = this.supTree.getClass(clsSrcName);
        this.assertTrue(supCls != null || this.visitedIncomingParentElements.contains(clsSrcName), notFoundMessage);
        return supCls;
    }

    @Nullable
    private MappingTreeView.MethodMappingView getVisitedSupMth(MappingTreeView.ClassMappingView supCls, String mthSrcName, String mthSrcDesc, String notFoundMessage) {
        MappingTreeView.MethodMappingView supMth = supCls.getMethod(mthSrcName, mthSrcDesc);
        this.assertTrue(supMth != null || this.visitedIncomingParentElements.contains(mthSrcName), notFoundMessage);
        return supMth;
    }
}

