/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.IgnorableReturnValue;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0080\u0080\u0004\u001a\u0012\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0081\u0080\u0004\u001a\u0016\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0081\u0080\u0004\u001a.\u0010\f\u001a\u00020\u0001*\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0081\u0080\u0004\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0081\u0080\u0004\u001a\u0012\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0015H\u0081\u0080\u0004\u001a\u000e\u0010\u001a\u001a\u00020\u0007*\u00020\u001bH\u0087\u0088\u0004\u001a\u000e\u0010\u001c\u001a\u00020\u001b*\u00020\u0007H\u0087\u0088\u0004\u001a\u000e\u0010\u001d\u001a\u00020\u0007*\u00020\u001eH\u0087\u0080\u0004\u001a\u0016\u0010\u001d\u001a\u00020\u0007*\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0087\u0080\u0004\u001a\u0016\u0010\u001f\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087\u0080\b\u001a\u001e\u0010\u001f\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087\u0080\b\u001a\u000e\u0010 \u001a\u00020\t*\u00020\tH\u0080\u0088\u0004\u00a8\u0006!"}, d2={"secureRandomBytes", "", "destination", "", "serializedUuid", "", "uuid", "Lkotlin/uuid/Uuid;", "getLongAt", "", "index", "", "formatBytesInto", "dst", "dstOffset", "startIndex", "endIndex", "setLongAt", "value", "uuidParseHexDash", "hexDashString", "", "uuidParseHexDashOrNull", "uuidParseHex", "hexString", "uuidParseHexOrNull", "toKotlinUuid", "Ljava/util/UUID;", "toJavaUuid", "getUuid", "Ljava/nio/ByteBuffer;", "putUuid", "reverseBytes", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,285:1\n284#1:286\n284#1:287\n284#1:288\n284#1:289\n284#1:290\n284#1:291\n284#1:292\n284#1:293\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n144#1:286\n145#1:287\n189#1:288\n190#1:289\n230#1:290\n231#1:291\n278#1:292\n279#1:293\n*E\n"})
class UuidKt__UuidJVMKt {
    public static final void secureRandomBytes(@NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(destination);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Object serializedUuid(@NotNull Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @ExperimentalUuidApi
    public static final long getLongAt(@NotNull byte[] $this$getLongAt, int index) {
        Intrinsics.checkNotNullParameter($this$getLongAt, "<this>");
        return UuidKt.getLongAtCommonImpl($this$getLongAt, index);
    }

    @ExperimentalUuidApi
    public static final void formatBytesInto(long $this$formatBytesInto, @NotNull byte[] dst, int dstOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        UuidKt.formatBytesIntoCommonImpl($this$formatBytesInto, dst, dstOffset, startIndex, endIndex);
    }

    @ExperimentalUuidApi
    public static final void setLongAt(@NotNull byte[] $this$setLongAt, int index, long value) {
        Intrinsics.checkNotNullParameter($this$setLongAt, "<this>");
        UuidKt.setLongAtCommonImpl($this$setLongAt, index, value);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHexDash(@NotNull String hexDashString) {
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        return UuidKt.uuidParseHexDashCommonImpl(hexDashString);
    }

    @ExperimentalUuidApi
    @Nullable
    public static final Uuid uuidParseHexDashOrNull(@NotNull String hexDashString) {
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        return UuidKt.uuidParseHexDashOrNullCommonImpl(hexDashString);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHex(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return UuidKt.uuidParseHexCommonImpl(hexString);
    }

    @ExperimentalUuidApi
    @Nullable
    public static final Uuid uuidParseHexOrNull(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return UuidKt.uuidParseHexOrNullCommonImpl(hexString);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid toKotlinUuid(@NotNull UUID $this$toKotlinUuid) {
        Intrinsics.checkNotNullParameter($this$toKotlinUuid, "<this>");
        boolean $i$f$toKotlinUuid = false;
        return Uuid.Companion.fromLongs($this$toKotlinUuid.getMostSignificantBits(), $this$toKotlinUuid.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final UUID toJavaUuid(@NotNull Uuid $this$toJavaUuid) {
        void leastSignificantBits;
        Intrinsics.checkNotNullParameter($this$toJavaUuid, "<this>");
        boolean $i$f$toJavaUuid = false;
        Uuid uuid = $this$toJavaUuid;
        long l15 = uuid.getLeastSignificantBits();
        long mostSignificantBits = uuid.getMostSignificantBits();
        boolean bl4 = false;
        return new UUID(mostSignificantBits, (long)leastSignificantBits);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if ($this$getUuid.position() + 15 >= $this$getUuid.limit()) {
            throw new BufferUnderflowException();
        }
        long msb = $this$getUuid.getLong();
        long lsb = $this$getUuid.getLong();
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid, int index) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$getUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + index + ", with limit: " + $this$getUuid.limit() + ' ');
        }
        long msb = $this$getUuid.getLong(index);
        long lsb = $this$getUuid.getLong(index + 8);
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @IgnorableReturnValue
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l15 = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl4 = false;
        if ($this$putUuid.position() + 15 >= $this$putUuid.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(msb);
            byteBuffer = $this$putUuid.putLong((long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @IgnorableReturnValue
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, int index, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l15 = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl4 = false;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$putUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + index + ", with limit: " + $this$putUuid.limit() + ' ');
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(index, msb);
            byteBuffer = $this$putUuid.putLong(index + 8, (long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(index, Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(index + 8, Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    public static final long reverseBytes(long $this$reverseBytes) {
        boolean $i$f$reverseBytes = false;
        return Long.reverseBytes($this$reverseBytes);
    }
}

