/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final long maxSize;
    private long currentPos;
    private long markPos;

    public LimitedInputStream(InputStream in4, long maxSize) {
        super(in4);
        this.maxSize = maxSize;
    }

    private void addAndCheckPos(long count) {
        this.currentPos += count;
        if (this.currentPos > this.maxSize) {
            throw new IllegalStateException("Read limit exceeded");
        }
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            this.addAndCheckPos(1L);
        }
        return data;
    }

    @Override
    public int read(byte[] b15, int off, int len) throws IOException {
        int count = super.read(b15, off, len);
        if (count > 0) {
            this.addAndCheckPos(count);
        }
        return count;
    }

    @Override
    public long skip(long n15) throws IOException {
        long skipped = super.skip(n15);
        if (skipped > 0L) {
            this.addAndCheckPos(skipped);
        }
        return skipped;
    }

    @Override
    public void mark(int readLimit) {
        super.mark(readLimit);
        this.markPos = this.currentPos;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.currentPos = this.markPos;
    }
}

