/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.kotlin.smap.pass;

import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.OrderedJadxPassInfo;
import jadx.api.plugins.pass.types.JadxPreparePass;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.plugins.kotlin.smap.KotlinSmapOptions;
import jadx.plugins.kotlin.smap.model.ClassAliasRename;
import jadx.plugins.kotlin.smap.utils.KotlinSmapUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljadx/plugins/kotlin/smap/pass/KotlinSourceDebugExtensionPass;", "Ljadx/api/plugins/pass/types/JadxPreparePass;", "options", "Ljadx/plugins/kotlin/smap/KotlinSmapOptions;", "<init>", "(Ljadx/plugins/kotlin/smap/KotlinSmapOptions;)V", "getInfo", "Ljadx/api/plugins/pass/JadxPassInfo;", "init", "", "root", "Ljadx/core/dex/nodes/RootNode;", "jadx-kotlin-source-debug-extension"})
public final class KotlinSourceDebugExtensionPass
implements JadxPreparePass {
    @NotNull
    private final KotlinSmapOptions options;

    public KotlinSourceDebugExtensionPass(@NotNull KotlinSmapOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.options = options;
    }

    @Override
    @NotNull
    public JadxPassInfo getInfo() {
        OrderedJadxPassInfo orderedJadxPassInfo = new OrderedJadxPassInfo("SourceDebugExtensionPrepare", "Use kotlin.jvm.internal.SourceDebugExtension annotation to rename class & package").before("RenameVisitor");
        Intrinsics.checkNotNullExpressionValue(orderedJadxPassInfo, "before(...)");
        return orderedJadxPassInfo;
    }

    @Override
    public void init(@NotNull RootNode root) {
        Intrinsics.checkNotNullParameter(root, "root");
        if (this.options.isClassAliasSourceDbg()) {
            for (ClassNode cls : root.getClasses()) {
                if (cls.contains(AFlag.DONT_RENAME)) continue;
                Intrinsics.checkNotNull(cls);
                ClassAliasRename kotlinCls = KotlinSmapUtils.getClassAlias(cls);
                if (kotlinCls == null) continue;
                cls.rename(kotlinCls.getName());
                cls.getPackageNode().rename(kotlinCls.getPkg());
            }
        }
    }
}

