/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.smali;

import com.android.tools.smali.smali.SmaliOptions;
import jadx.plugins.input.dex.utils.IDexData;
import jadx.plugins.input.dex.utils.SimpleDexData;
import jadx.plugins.input.smali.SmaliInputOptions;
import jadx.plugins.input.smali.SmaliUtils;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliConvert {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliConvert.class);
    private final List<IDexData> dexData = new ArrayList<IDexData>();

    public boolean execute(List<Path> input, SmaliInputOptions options) {
        List<Path> smaliFiles = this.filterSmaliFiles(input);
        if (smaliFiles.isEmpty()) {
            return false;
        }
        try {
            this.compile(smaliFiles, options);
        }
        catch (Exception e15) {
            LOG.error("Smali process error", e15);
        }
        return !this.dexData.isEmpty();
    }

    private void compile(List<Path> inputFiles, SmaliInputOptions options) {
        SmaliOptions smaliOptions = new SmaliOptions();
        smaliOptions.apiLevel = options.getApiLevel();
        smaliOptions.verboseErrors = true;
        smaliOptions.allowOdexOpcodes = false;
        smaliOptions.printTokens = false;
        int threads = options.getThreads();
        LOG.debug("Compiling smali files: {}, threads: {}", (Object)inputFiles.size(), (Object)threads);
        long start = System.currentTimeMillis();
        if (threads == 1 || inputFiles.size() == 1) {
            for (Path inputFile : inputFiles) {
                this.assemble(this.dexData, inputFile, smaliOptions);
            }
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(threads);
                List<IDexData> syncList = Collections.synchronizedList(this.dexData);
                for (Path inputFile : inputFiles) {
                    executor.execute(() -> this.assemble(syncList, inputFile, smaliOptions));
                }
                executor.shutdown();
                executor.awaitTermination(1L, TimeUnit.HOURS);
                this.dexData.sort(Comparator.comparing(IDexData::getFileName));
            }
            catch (InterruptedException e15) {
                LOG.error("Smali compile interrupted", e15);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Smali compile done in: {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void assemble(List<IDexData> results, Path inputFile, SmaliOptions smaliOptions) {
        Path path = inputFile.toAbsolutePath();
        try {
            byte[] dexContent = SmaliUtils.assemble(path.toFile(), smaliOptions);
            results.add(new SimpleDexData(path.toString(), dexContent));
        }
        catch (Exception e15) {
            LOG.error("Failed to assemble smali file: {}", (Object)path, (Object)e15);
        }
    }

    private List<Path> filterSmaliFiles(List<Path> input) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.smali");
        return input.stream().filter(matcher::matches).collect(Collectors.toList());
    }

    public List<IDexData> getDexData() {
        return this.dexData;
    }
}

