/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.utils;

import jadx.plugins.input.java.utils.JavaClassParseException;
import java.nio.charset.StandardCharsets;

public class ModifiedUTF8Decoder {
    public static String decodeString(byte[] bytes) {
        int len = bytes.length;
        boolean asciiStr = true;
        for (byte b15 : bytes) {
            if ((b15 & 0x80) == 0) continue;
            asciiStr = false;
            break;
        }
        if (asciiStr) {
            return new String(bytes, StandardCharsets.US_ASCII);
        }
        StringBuilder sb5 = new StringBuilder();
        for (int i15 = 0; i15 < len; ++i15) {
            int x15 = bytes[i15] & 0xFF;
            if ((x15 & 0x80) == 0) {
                sb5.append((char)x15);
                continue;
            }
            if (i15 + 1 >= len) {
                throw new JavaClassParseException("Inconsistent byte array structure: too short");
            }
            int y15 = bytes[i15 + 1] & 0xFF;
            if (x15 == 192 && y15 == 128) {
                sb5.appendCodePoint(0);
                ++i15;
                continue;
            }
            if ((x15 & 0xE0) == 192 && (y15 & 0xC0) == 128) {
                sb5.appendCodePoint(((x15 & 0x1F) << 6) + (y15 & 0x3F));
                ++i15;
                continue;
            }
            if (i15 + 2 >= len) continue;
            int z15 = bytes[i15 + 2] & 0xFF;
            if ((x15 & 0xF0) == 224 && (y15 & 0xC0) == 128 && (z15 & 0xC0) == 128) {
                sb5.appendCodePoint(((x15 & 0xF) << 12) + ((y15 & 0x3F) << 6) + (z15 & 0x3F));
                i15 += 2;
                continue;
            }
            if (i15 + 5 < len && x15 == 237 && (y15 & 0xF0) == 160 && (bytes[i15 + 3] & 0xFF) == 237 && (bytes[i15 + 4] & 0xF0) == 160) {
                int u15 = x15;
                int v15 = y15;
                int w15 = z15;
                x15 = bytes[i15 + 3] & 0xFF;
                y15 = bytes[i15 + 4] & 0xFF;
                z15 = bytes[i15 + 5] & 0xFF;
                if (x15 == 237 && (y15 & 0xF0) == 160) {
                    sb5.appendCodePoint(65536 + ((v15 & 0xF) << 16) + ((w15 & 0x3F) << 10) + ((y15 & 0xF) << 6) + (z15 & 0x3F));
                    i15 += 5;
                    continue;
                }
                throw new JavaClassParseException("Inconsistent byte array structure: invalid 6 bytes char");
            }
            throw new JavaClassParseException("Inconsistent byte array structure: unexpected char");
        }
        return sb5.toString();
    }
}

