/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.debuginfo.LineNumberTableAttr;
import jadx.plugins.input.java.data.attributes.debuginfo.LocalVarTypesAttr;
import jadx.plugins.input.java.data.attributes.debuginfo.LocalVarsAttr;
import jadx.plugins.input.java.data.attributes.stack.StackMapTableReader;
import jadx.plugins.input.java.data.attributes.types.CodeAttr;
import jadx.plugins.input.java.data.attributes.types.ConstValueAttr;
import jadx.plugins.input.java.data.attributes.types.IgnoredAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationDefaultAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaBootstrapMethodsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaExceptionsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaInnerClsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaMethodParametersAttr;
import jadx.plugins.input.java.data.attributes.types.JavaParamAnnsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaSignatureAttr;
import jadx.plugins.input.java.data.attributes.types.JavaSourceFileAttr;
import jadx.plugins.input.java.data.attributes.types.StackMapTableAttr;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class JavaAttrType<T extends IJavaAttribute> {
    private static final Map<String, JavaAttrType<?>> NAME_TO_TYPE_MAP = new HashMap();
    public static final JavaAttrType<JavaInnerClsAttr> INNER_CLASSES;
    public static final JavaAttrType<JavaBootstrapMethodsAttr> BOOTSTRAP_METHODS;
    public static final JavaAttrType<ConstValueAttr> CONST_VALUE;
    public static final JavaAttrType<CodeAttr> CODE;
    public static final JavaAttrType<StackMapTableAttr> STACK_MAP_TABLE;
    public static final JavaAttrType<LineNumberTableAttr> LINE_NUMBER_TABLE;
    public static final JavaAttrType<LocalVarsAttr> LOCAL_VAR_TABLE;
    public static final JavaAttrType<LocalVarTypesAttr> LOCAL_VAR_TYPE_TABLE;
    public static final JavaAttrType<JavaAnnotationsAttr> RUNTIME_ANNOTATIONS;
    public static final JavaAttrType<JavaAnnotationsAttr> BUILD_ANNOTATIONS;
    public static final JavaAttrType<JavaParamAnnsAttr> RUNTIME_PARAMETER_ANNOTATIONS;
    public static final JavaAttrType<JavaParamAnnsAttr> BUILD_PARAMETER_ANNOTATIONS;
    public static final JavaAttrType<IgnoredAttr> RUNTIME_TYPE_ANNOTATIONS;
    public static final JavaAttrType<IgnoredAttr> BUILD_TYPE_ANNOTATIONS;
    public static final JavaAttrType<JavaAnnotationDefaultAttr> ANNOTATION_DEFAULT;
    public static final JavaAttrType<JavaSourceFileAttr> SOURCE_FILE;
    public static final JavaAttrType<JavaSignatureAttr> SIGNATURE;
    public static final JavaAttrType<JavaExceptionsAttr> EXCEPTIONS;
    public static final JavaAttrType<JavaMethodParametersAttr> METHOD_PARAMETERS;
    public static final JavaAttrType<IgnoredAttr> DEPRECATED;
    public static final JavaAttrType<IgnoredAttr> SYNTHETIC;
    public static final JavaAttrType<IgnoredAttr> ENCLOSING_METHOD;
    public static final JavaAttrType<IgnoredAttr> MODULE;
    public static final JavaAttrType<IgnoredAttr> SOURCE_DEBUG_EXTENSION;
    public static final JavaAttrType<IgnoredAttr> NEST_HOST;
    public static final JavaAttrType<IgnoredAttr> NEST_MEMBERS;
    private final int id;
    private final String name;
    private final IJavaAttributeReader reader;

    private static <A extends IJavaAttribute> JavaAttrType<A> bind(String name, IJavaAttributeReader reader) {
        JavaAttrType attrType = new JavaAttrType(NAME_TO_TYPE_MAP.size(), name, reader);
        NAME_TO_TYPE_MAP.put(name, attrType);
        return attrType;
    }

    @Nullable
    public static JavaAttrType<?> byName(String name) {
        return NAME_TO_TYPE_MAP.get(name);
    }

    public static int size() {
        return NAME_TO_TYPE_MAP.size();
    }

    private JavaAttrType(int id5, String name, IJavaAttributeReader reader) {
        this.id = id5;
        this.name = name;
        this.reader = reader;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IJavaAttributeReader getReader() {
        return this.reader;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        return this.id == ((JavaAttrType)o15).id;
    }

    public String toString() {
        return this.name;
    }

    static {
        CONST_VALUE = JavaAttrType.bind("ConstantValue", ConstValueAttr.reader());
        CODE = JavaAttrType.bind("Code", CodeAttr.reader());
        LINE_NUMBER_TABLE = JavaAttrType.bind("LineNumberTable", LineNumberTableAttr.reader());
        LOCAL_VAR_TABLE = JavaAttrType.bind("LocalVariableTable", LocalVarsAttr.reader());
        LOCAL_VAR_TYPE_TABLE = JavaAttrType.bind("LocalVariableTypeTable", LocalVarTypesAttr.reader());
        INNER_CLASSES = JavaAttrType.bind("InnerClasses", JavaInnerClsAttr.reader());
        BOOTSTRAP_METHODS = JavaAttrType.bind("BootstrapMethods", JavaBootstrapMethodsAttr.reader());
        RUNTIME_ANNOTATIONS = JavaAttrType.bind("RuntimeVisibleAnnotations", JavaAnnotationsAttr.reader(AnnotationVisibility.RUNTIME));
        BUILD_ANNOTATIONS = JavaAttrType.bind("RuntimeInvisibleAnnotations", JavaAnnotationsAttr.reader(AnnotationVisibility.BUILD));
        RUNTIME_PARAMETER_ANNOTATIONS = JavaAttrType.bind("RuntimeVisibleParameterAnnotations", JavaParamAnnsAttr.reader(AnnotationVisibility.RUNTIME));
        BUILD_PARAMETER_ANNOTATIONS = JavaAttrType.bind("RuntimeInvisibleParameterAnnotations", JavaParamAnnsAttr.reader(AnnotationVisibility.BUILD));
        ANNOTATION_DEFAULT = JavaAttrType.bind("AnnotationDefault", JavaAnnotationDefaultAttr.reader());
        SOURCE_FILE = JavaAttrType.bind("SourceFile", JavaSourceFileAttr.reader());
        SIGNATURE = JavaAttrType.bind("Signature", JavaSignatureAttr.reader());
        EXCEPTIONS = JavaAttrType.bind("Exceptions", JavaExceptionsAttr.reader());
        METHOD_PARAMETERS = JavaAttrType.bind("MethodParameters", JavaMethodParametersAttr.reader());
        STACK_MAP_TABLE = JavaAttrType.bind("StackMapTable", new StackMapTableReader());
        DEPRECATED = JavaAttrType.bind("Deprecated", null);
        SYNTHETIC = JavaAttrType.bind("Synthetic", null);
        ENCLOSING_METHOD = JavaAttrType.bind("EnclosingMethod", null);
        RUNTIME_TYPE_ANNOTATIONS = JavaAttrType.bind("RuntimeVisibleTypeAnnotations", null);
        BUILD_TYPE_ANNOTATIONS = JavaAttrType.bind("RuntimeInvisibleTypeAnnotations", null);
        MODULE = JavaAttrType.bind("Module", null);
        NEST_HOST = JavaAttrType.bind("NestHost", null);
        NEST_MEMBERS = JavaAttrType.bind("NestMembers", null);
        SOURCE_DEBUG_EXTENSION = JavaAttrType.bind("SourceDebugExtension", null);
    }
}

