/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes;

import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesReader {
    private static final Logger LOG = LoggerFactory.getLogger(AttributesReader.class);
    private static final Predicate<JavaAttrType<?>> LOAD_ALL = type -> true;
    private final JavaClassData clsData;
    private final ConstPoolReader constPool;
    private final Map<Integer, JavaAttrType<?>> attrCache = new HashMap(JavaAttrType.size());

    public AttributesReader(JavaClassData clsData, ConstPoolReader constPoolReader) {
        this.clsData = clsData;
        this.constPool = constPoolReader;
    }

    public JavaAttrStorage loadAll(DataReader reader) {
        return this.loadAttributes(reader, LOAD_ALL);
    }

    public JavaAttrStorage loadMulti(DataReader reader, Set<JavaAttrType<?>> types) {
        return this.loadAttributes(reader, types::contains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaAttrStorage loadAttributes(DataReader reader, Predicate<JavaAttrType<?>> condition2) {
        int count = reader.readU2();
        if (count == 0) {
            return JavaAttrStorage.EMPTY;
        }
        JavaAttrStorage storage = new JavaAttrStorage();
        for (int i15 = 0; i15 < count; ++i15) {
            int nameIdx = reader.readU2();
            int len = reader.readU4();
            int end = reader.getOffset() + len;
            try {
                IJavaAttribute attrValue;
                IJavaAttributeReader attrReader;
                JavaAttrType<?> attrType = this.resolveAttrReader(nameIdx);
                if (attrType == null || !condition2.test(attrType) || (attrReader = attrType.getReader()) == null || (attrValue = attrReader.read(this.clsData, reader)) == null) continue;
                storage.add(attrType, attrValue);
                continue;
            }
            catch (Exception e15) {
                LOG.error("Failed to parse attribute: {}", (Object)this.constPool.getUtf8(nameIdx), (Object)e15);
                continue;
            }
            finally {
                reader.absPos(end);
            }
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends IJavaAttribute> T loadOne(DataReader reader, JavaAttrType<T> type) {
        int count = reader.readU2();
        for (int i15 = 0; i15 < count; ++i15) {
            int nameIdx = reader.readU2();
            int len = reader.readU4();
            int end = reader.getOffset() + len;
            try {
                JavaAttrType<?> attrType = this.resolveAttrReader(nameIdx);
                if (attrType != type) continue;
                IJavaAttribute iJavaAttribute = attrType.getReader().read(this.clsData, reader);
                return (T)iJavaAttribute;
            }
            catch (Exception e15) {
                LOG.error("Failed to parse attribute: {}", (Object)this.constPool.getUtf8(nameIdx), (Object)e15);
                continue;
            }
            finally {
                reader.absPos(end);
            }
        }
        return null;
    }

    private JavaAttrType<?> resolveAttrReader(int nameIdx) {
        return this.attrCache.computeIfAbsent(nameIdx, idx -> {
            String attrName = this.constPool.getUtf8((int)idx);
            JavaAttrType<?> attrType = JavaAttrType.byName(attrName);
            if (attrType == null) {
                LOG.warn("Unknown java class attribute type: {}", (Object)attrName);
                return null;
            }
            return attrType;
        });
    }
}

