/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultClassAttr;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.api.plugins.input.data.attributes.types.ExceptionsAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClassesAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClsInfo;
import jadx.api.plugins.input.data.attributes.types.MethodParametersAttr;
import jadx.api.plugins.input.data.attributes.types.SignatureAttr;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.sections.annotations.AnnotationsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DexAnnotationsConvert {
    private static final Logger LOG = LoggerFactory.getLogger(DexAnnotationsConvert.class);

    public static void forClass(String cls, List<IJadxAttribute> list2, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(cls, list2, annotationList);
    }

    public static void forMethod(List<IJadxAttribute> list2, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(null, list2, annotationList);
    }

    public static void forField(List<IJadxAttribute> list2, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(null, list2, annotationList);
    }

    private static void appendAnnotations(@Nullable String cls, List<IJadxAttribute> attributes, List<IAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        for (IAnnotation annotation : annotations) {
            if (annotation.getVisibility() != AnnotationVisibility.SYSTEM) continue;
            DexAnnotationsConvert.convertSystemAnnotations(cls, attributes, annotation);
        }
        Utils.addToList(attributes, AnnotationsAttr.pack(annotations));
    }

    private static void convertSystemAnnotations(@Nullable String cls, List<IJadxAttribute> attributes, IAnnotation annotation) {
        switch (annotation.getAnnotationClass()) {
            case "Ldalvik/annotation/Signature;": {
                attributes.add(new SignatureAttr(DexAnnotationsConvert.extractSignature(annotation)));
                break;
            }
            case "Ldalvik/annotation/InnerClass;": {
                try {
                    String name = AnnotationsUtils.getValue(annotation, "name", EncodedType.ENCODED_STRING, null);
                    int accFlags = AnnotationsUtils.getValue(annotation, "accessFlags", EncodedType.ENCODED_INT, 0);
                    if (name == null && accFlags == 0) break;
                    InnerClsInfo innerClsInfo = new InnerClsInfo(cls, null, name, accFlags);
                    attributes.add(new InnerClassesAttr(Collections.singletonMap(cls, innerClsInfo)));
                }
                catch (Exception e15) {
                    LOG.warn("Failed to parse annotation: {}", (Object)annotation, (Object)e15);
                }
                break;
            }
            case "Ldalvik/annotation/AnnotationDefault;": {
                EncodedValue annValue = annotation.getDefaultValue();
                if (annValue == null || annValue.getType() != EncodedType.ENCODED_ANNOTATION) break;
                IAnnotation defAnnotation = (IAnnotation)annValue.getValue();
                attributes.add(new AnnotationDefaultClassAttr(defAnnotation.getValues()));
                break;
            }
            case "Ldalvik/annotation/Throws;": {
                try {
                    EncodedValue defaultValue = annotation.getDefaultValue();
                    if (defaultValue == null) break;
                    List<String> excs = ((List)defaultValue.getValue()).stream().map(ev4 -> (String)ev4.getValue()).collect(Collectors.toList());
                    attributes.add(new ExceptionsAttr(excs));
                }
                catch (Exception e16) {
                    LOG.warn("Failed to convert dalvik throws annotation", e16);
                }
                break;
            }
            case "Ldalvik/annotation/MethodParameters;": {
                try {
                    List<EncodedValue> names = AnnotationsUtils.getArray(annotation, "names");
                    List<EncodedValue> accFlags = AnnotationsUtils.getArray(annotation, "accessFlags");
                    if (names.isEmpty() || names.size() != accFlags.size()) break;
                    int size = names.size();
                    ArrayList<MethodParametersAttr.Info> list2 = new ArrayList<MethodParametersAttr.Info>(size);
                    for (int i15 = 0; i15 < size; ++i15) {
                        String name = (String)names.get(i15).getValue();
                        int accFlag = (Integer)accFlags.get(i15).getValue();
                        list2.add(new MethodParametersAttr.Info(accFlag, name));
                    }
                    attributes.add(new MethodParametersAttr(list2));
                    break;
                }
                catch (Exception e17) {
                    LOG.warn("Failed to parse annotation: {}", (Object)annotation, (Object)e17);
                }
            }
        }
    }

    private static String extractSignature(IAnnotation annotation) {
        List values2 = (List)annotation.getDefaultValue().getValue();
        if (values2.size() == 1) {
            return (String)((EncodedValue)values2.get(0)).getValue();
        }
        StringBuilder sb5 = new StringBuilder();
        for (EncodedValue part : values2) {
            sb5.append((String)part.getValue());
        }
        return sb5.toString();
    }
}

