/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class FontPanel
extends ContentPanel {
    private static final long serialVersionUID = 695370628262996993L;
    private static final String DEFAULT_PREVIEW_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890!@#$%^&*()_-=+[]{}<,.>";

    public FontPanel(TabbedPane panel, JResource res) {
        super(panel, res);
        this.setLayout(new BorderLayout());
        RSyntaxTextArea textArea = AbstractCodeArea.getDefaultArea(panel.getMainWindow());
        this.add((Component)textArea, "Center");
        try {
            Font selectedFont = this.loadFont(res);
            if (selectedFont.canDisplay(DEFAULT_PREVIEW_STRING.codePointAt(0))) {
                textArea.setFont(selectedFont);
                textArea.setText(DEFAULT_PREVIEW_STRING);
            } else {
                textArea.setText(NLS.str("message.unable_preview_font"));
            }
        }
        catch (Exception e15) {
            textArea.setText("Font load error:\n" + Utils.getStackTrace(e15));
        }
    }

    private Font loadFont(JResource res) {
        ResourceFile resFile = res.getResFile();
        ResContainer resContainer = resFile.loadContent();
        ResContainer.DataType dataType = resContainer.getDataType();
        if (dataType == ResContainer.DataType.DECODED_DATA) {
            try {
                return Font.createFont(0, new ByteArrayInputStream(resContainer.getDecodedData())).deriveFont(12.0f);
            }
            catch (Exception e15) {
                throw new JadxRuntimeException("Failed to load font", e15);
            }
        }
        if (dataType == ResContainer.DataType.RES_LINK) {
            try {
                return ResourcesLoader.decodeStream(resFile, (size, is4) -> {
                    try {
                        return Font.createFont(0, is4).deriveFont(12.0f);
                    }
                    catch (FontFormatException e15) {
                        throw new JadxRuntimeException("Failed to load font", e15);
                    }
                });
            }
            catch (Exception e16) {
                throw new JadxRuntimeException("Failed to load font", e16);
            }
        }
        throw new JadxRuntimeException("Unsupported resource font data type: " + String.valueOf(resFile));
    }

    @Override
    public void loadSettings() {
    }
}

