/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer;

import jadx.core.utils.StringUtils;
import jadx.gui.ui.hexviewer.HexPreviewPanel;
import jadx.gui.ui.hexviewer.search.BinarySearch;
import jadx.gui.ui.hexviewer.search.SearchCondition;
import jadx.gui.ui.hexviewer.search.SearchParameters;
import jadx.gui.ui.hexviewer.search.service.BinarySearchServiceImpl;
import jadx.gui.utils.HexUtils;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.exbin.auxiliary.binary_data.array.ByteArrayEditableData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.swing.section.SectCodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexSearchBar
extends JToolBar {
    private static final long serialVersionUID = 1836871286618633003L;
    private static final Logger LOG = LoggerFactory.getLogger(HexSearchBar.class);
    private final SectCodeArea hexCodeArea;
    private final JTextField searchField;
    private final JLabel resultCountLabel;
    private final JToggleButton markAllCB;
    private final JToggleButton findTypeCB;
    private final JToggleButton matchCaseCB;
    private final JButton nextMatchButton;
    private final JButton prevMatchButton;
    private Control control = null;

    public HexSearchBar(SectCodeArea textArea) {
        this.hexCodeArea = textArea;
        JLabel findLabel = new JLabel(NLS.str("search.find") + ":");
        this.add(findLabel);
        this.searchField = new JTextField(30);
        this.searchField.putClientProperty("JTextField.showClearButton", true);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e15) {
                switch (e15.getKeyCode()) {
                    case 10: {
                        break;
                    }
                    case 27: {
                        HexSearchBar.this.toggle();
                        break;
                    }
                    default: {
                        HexSearchBar.this.control.performFind();
                    }
                }
            }
        });
        this.searchField.addActionListener(e15 -> this.control.notifySearchChanging());
        TextStandardActions.attach(this.searchField);
        this.add(this.searchField);
        ActionListener searchSettingListener = e15 -> this.control.notifySearchChanged();
        this.resultCountLabel = new JLabel();
        this.resultCountLabel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.resultCountLabel.setForeground(Color.GRAY);
        this.add(this.resultCountLabel);
        this.matchCaseCB = new JToggleButton();
        this.matchCaseCB.setIcon(Icons.ICON_MATCH);
        this.matchCaseCB.setSelectedIcon(Icons.ICON_MATCH_SELECTED);
        this.matchCaseCB.setToolTipText(NLS.str("search.match_case"));
        this.matchCaseCB.addActionListener(searchSettingListener);
        this.add(this.matchCaseCB);
        this.findTypeCB = new JToggleButton();
        this.findTypeCB.setIcon(Icons.ICON_FIND_TYPE_TXT);
        this.findTypeCB.setSelectedIcon(Icons.ICON_FIND_TYPE_HEX);
        if (this.findTypeCB.isSelected()) {
            this.findTypeCB.setToolTipText(NLS.str("search.find_type_hex"));
        } else {
            this.findTypeCB.setToolTipText(NLS.str("search.find_type_text"));
        }
        this.findTypeCB.addActionListener(e15 -> {
            this.searchField.setText("");
            this.updateFindStatus();
            this.control.notifySearchChanged();
        });
        this.add(this.findTypeCB);
        this.prevMatchButton = new JButton();
        this.prevMatchButton.setIcon(Icons.ICON_UP);
        this.prevMatchButton.setToolTipText(NLS.str("search.previous"));
        this.prevMatchButton.addActionListener(e15 -> this.control.prevMatch());
        this.prevMatchButton.setBorderPainted(false);
        this.add(this.prevMatchButton);
        this.nextMatchButton = new JButton();
        this.nextMatchButton.setIcon(Icons.ICON_DOWN);
        this.nextMatchButton.setToolTipText(NLS.str("search.next"));
        this.nextMatchButton.addActionListener(e15 -> this.control.nextMatch());
        this.nextMatchButton.setBorderPainted(false);
        this.add(this.nextMatchButton);
        this.markAllCB = new JToggleButton();
        this.markAllCB.setIcon(Icons.ICON_MARK);
        this.markAllCB.setSelectedIcon(Icons.ICON_MARK_SELECTED);
        this.markAllCB.setToolTipText(NLS.str("search.mark_all"));
        this.markAllCB.setSelected(true);
        this.markAllCB.addActionListener(searchSettingListener);
        this.add(this.markAllCB);
        JButton closeButton = new JButton();
        closeButton.setIcon(Icons.ICON_CLOSE);
        closeButton.addActionListener(e15 -> this.toggle());
        closeButton.setBorderPainted(false);
        this.add(closeButton);
        BinarySearch binarySearch = new BinarySearch(this);
        binarySearch.setBinarySearchService(new BinarySearchServiceImpl(this.hexCodeArea));
        this.setFloatable(false);
        this.setVisible(false);
    }

    public void showAndFocus() {
        String selectedText;
        this.setVisible(true);
        if (this.hexCodeArea.hasSelection()) {
            this.searchField.setText(this.hexCodeArea.getActiveSection().toString());
        }
        if (!StringUtils.isEmpty(selectedText = HexPreviewPanel.getSelectionData(this.hexCodeArea))) {
            this.searchField.setText(selectedText);
            this.makeFindByHexButton();
        }
        this.searchField.selectAll();
        this.searchField.requestFocus();
    }

    public void toggle() {
        boolean visible = !this.isVisible();
        this.setVisible(visible);
        if (visible) {
            String preferText = HexPreviewPanel.getSelectionData(this.hexCodeArea);
            if (!StringUtils.isEmpty(preferText)) {
                this.searchField.setText(preferText);
                this.makeFindByHexButton();
            }
            this.searchField.selectAll();
            this.searchField.requestFocus();
        } else {
            this.control.performEscape();
            this.hexCodeArea.requestFocus();
        }
    }

    public void setInfoLabel(String text) {
        this.resultCountLabel.setText(text);
    }

    public void updateMatchCount(boolean hasMatches, boolean prevMatchAvailable, boolean nextMatchAvailable) {
        this.prevMatchButton.setEnabled(prevMatchAvailable);
        this.nextMatchButton.setEnabled(nextMatchAvailable);
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void clearSearch() {
        this.setInfoLabel("");
        this.searchField.setText("");
    }

    public SearchParameters getSearchParameters() {
        long startPosition;
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setMatchCase(this.matchCaseCB.isSelected());
        searchParameters.setMatchMode(SearchParameters.MatchMode.fromBoolean(this.markAllCB.isSelected()));
        SearchParameters.SearchDirection searchDirection = this.control.getSearchDirection();
        searchParameters.setSearchDirection(searchDirection);
        if (searchParameters.isSearchFromCursor()) {
            startPosition = this.hexCodeArea.getActiveCaretPosition().getDataPosition();
        } else {
            switch (searchDirection) {
                case FORWARD: {
                    startPosition = 0L;
                    break;
                }
                case BACKWARD: {
                    startPosition = this.hexCodeArea.getDataSize() - 1L;
                    break;
                }
                default: {
                    throw CodeAreaUtils.getInvalidTypeException(searchDirection);
                }
            }
        }
        searchParameters.setStartPosition(startPosition);
        searchParameters.setCondition(new SearchCondition(this.makeSearchCondition()));
        return searchParameters;
    }

    private SearchCondition makeSearchCondition() {
        SearchCondition condition2 = new SearchCondition();
        if (this.findTypeCB.isSelected()) {
            condition2.setSearchMode(SearchCondition.SearchMode.BINARY);
        } else {
            condition2.setSearchMode(SearchCondition.SearchMode.TEXT);
        }
        if (!StringUtils.isEmpty(this.searchField.getText())) {
            if (condition2.getSearchMode() == SearchCondition.SearchMode.TEXT) {
                condition2.setSearchText(this.searchField.getText());
            } else {
                String hexBytes = this.searchField.getText();
                boolean isValidHexInput = HexUtils.isValidHexString(hexBytes);
                UiUtils.highlightAsErrorField(this.searchField, !isValidHexInput);
                if (isValidHexInput) {
                    condition2.setBinaryData(new ByteArrayEditableData(HexUtils.hexStringToByteArray(hexBytes)));
                }
            }
        }
        return condition2;
    }

    public void updateFindStatus() {
        UiUtils.highlightAsErrorField(this.searchField, false);
        SearchCondition condition2 = this.makeSearchCondition();
        if (condition2.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.findTypeCB.setSelected(false);
            this.findTypeCB.setToolTipText(NLS.str("search.find_type_text"));
            this.matchCaseCB.setEnabled(true);
        } else {
            this.makeFindByHexButton();
            this.matchCaseCB.setEnabled(false);
        }
    }

    private void makeFindByHexButton() {
        this.findTypeCB.setSelected(true);
        this.findTypeCB.setToolTipText(NLS.str("search.find_type_hex"));
    }

    public static interface Control {
        public void prevMatch();

        public void nextMatch();

        public void performEscape();

        public void performFind();

        public void notifySearchChanged();

        public void notifySearchChanging();

        public SearchParameters.SearchDirection getSearchDirection();

        public void close();
    }
}

