/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import hu.akarnokd.rxjava3.swing.SwingSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.FocusManager;
import javax.swing.JProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapUsageBar
extends JProgressBar {
    private static final long serialVersionUID = -8739563124249884967L;
    private static final Logger LOG = LoggerFactory.getLogger(HeapUsageBar.class);
    private static final double GB = 1.073741824E9;
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color RED = new Color(200, 0, 0);
    private final transient Runtime runtime = Runtime.getRuntime();
    private final transient FocusManager focusManager = FocusManager.getCurrentManager();
    private final double maxGB;
    private final long limit;
    private final String labelTemplate;
    private transient Disposable timer;
    private transient Color currentColor;
    private static final UpdateData SKIP_UPDATE = new UpdateData();

    public HeapUsageBar() {
        this.setBorderPainted(false);
        this.setStringPainted(true);
        long maxMemory = this.runtime.maxMemory();
        this.maxGB = (double)maxMemory / 1.073741824E9;
        this.limit = maxMemory - UiUtils.MIN_FREE_MEMORY;
        this.labelTemplate = NLS.str("heapUsage.text");
        this.setMaximum((int)(maxMemory / 1024L));
        this.setColor(GREEN);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e15) {
                Runtime.getRuntime().gc();
                HeapUsageBar.this.update();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Memory used: {}", (Object)UiUtils.memoryInfo());
                }
            }
        });
    }

    @Override
    public void setVisible(boolean enabled) {
        super.setVisible(enabled);
        if (enabled) {
            this.startTimer();
        } else {
            this.reset();
        }
    }

    private void startTimer() {
        if (this.timer != null) {
            return;
        }
        this.update();
        this.timer = Flowable.interval(2L, TimeUnit.SECONDS, Schedulers.newThread()).map(i15 -> this.prepareUpdate()).filter(update -> update != SKIP_UPDATE).distinctUntilChanged((a15, b15) -> Objects.equals(a15.label, b15.label)).subscribeOn(SwingSchedulers.edt()).subscribe(this::applyUpdate);
    }

    public UpdateData prepareUpdate() {
        if (this.focusManager.getActiveWindow() == null) {
            return SKIP_UPDATE;
        }
        UpdateData updateData = new UpdateData();
        long used = this.runtime.totalMemory() - this.runtime.freeMemory();
        updateData.value = (int)(used / 1024L);
        updateData.label = String.format(this.labelTemplate, (double)used / 1.073741824E9, this.maxGB);
        updateData.color = used > this.limit ? RED : GREEN;
        return updateData;
    }

    public void applyUpdate(UpdateData update) {
        this.setValue(update.value);
        this.setString(update.label);
        this.setColor(update.color);
    }

    private void setColor(Color color) {
        if (this.currentColor != color) {
            this.setForeground(color);
            this.currentColor = color;
        }
    }

    private void update() {
        UpdateData update = this.prepareUpdate();
        if (update != SKIP_UPDATE) {
            this.applyUpdate(update);
        }
    }

    public void reset() {
        if (this.timer != null) {
            this.timer.dispose();
            this.timer = null;
        }
    }

    private static class UpdateData {
        int value;
        String label;
        Color color;

        private UpdateData() {
        }
    }
}

