/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.JadxArgs;
import jadx.api.args.GeneratedRenamesMappingFileMode;
import jadx.api.args.IntegerFormat;
import jadx.api.args.ResourceNameSource;
import jadx.api.args.UseSourceNameAsClassNameAlias;
import jadx.api.args.UserRenamesMappingsMode;
import jadx.cli.config.JadxConfigAdapter;
import jadx.cli.config.JadxConfigExclude;
import jadx.core.utils.GsonUtils;
import jadx.gui.cache.code.CodeCacheMode;
import jadx.gui.cache.usage.UsageCacheMode;
import jadx.gui.settings.JadxConfigExcludeExport;
import jadx.gui.settings.JadxSettingsData;
import jadx.gui.settings.JadxUpdateChannel;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.settings.WindowLocation;
import jadx.gui.settings.XposedCodegenLanguage;
import jadx.gui.settings.data.SaveOptionEnum;
import jadx.gui.settings.data.ShortcutsWrapper;
import jadx.gui.settings.font.FontSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.dnd.TabDndGhostType;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.PathTypeAdapter;
import jadx.gui.utils.RectangleTypeAdapter;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettings {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettings.class);
    private static final int RECENT_PROJECTS_COUNT = 30;
    private final JadxConfigAdapter<JadxSettingsData> configAdapter;
    private final Object dataWriteSync = new Object();
    private final ShortcutsWrapper shortcutsWrapper = new ShortcutsWrapper();
    private final FontSettings fontSettings = new FontSettings();
    private JadxSettingsData settingsData;

    public JadxSettings(JadxConfigAdapter<JadxSettingsData> configAdapter) {
        this.configAdapter = configAdapter;
    }

    public static JadxConfigAdapter<JadxSettingsData> buildConfigAdapter() {
        return new JadxConfigAdapter<JadxSettingsData>(JadxSettingsData.class, "gui", gsonBuilder -> {
            gsonBuilder.registerTypeHierarchyAdapter(Path.class, PathTypeAdapter.singleton());
            gsonBuilder.registerTypeHierarchyAdapter(Rectangle.class, RectangleTypeAdapter.singleton());
        });
    }

    public String getSettingsJsonString() {
        return this.configAdapter.objectToJsonString(this.settingsData);
    }

    public void loadSettingsFromJsonString(String jsonStr) {
        this.loadSettingsData(this.configAdapter.jsonStringToObject(jsonStr));
    }

    public void loadSettingsData(JadxSettingsData settingsData) {
        this.settingsData = settingsData;
        this.upgradeSettings(settingsData.getSettingsVersion());
        this.fixOnLoad();
        this.shortcutsWrapper.updateShortcuts(settingsData.getShortcuts());
        this.fontSettings.bindData(settingsData);
    }

    private void upgradeSettings(int fromVersion) {
        if (this.settingsData.getSettingsVersion() == 23) {
            return;
        }
        LOG.debug("upgrade settings from version: {} to {}", (Object)fromVersion, (Object)23);
        if (fromVersion <= 22) {
            ++fromVersion;
        }
        if (fromVersion != 23) {
            LOG.warn("Incorrect settings upgrade. Expected version: {}, got: {}", (Object)23, (Object)fromVersion);
        }
        this.settingsData.setSettingsVersion(23);
        this.sync();
    }

    private void fixOnLoad() {
        if (this.settingsData.getThreadsCount() <= 0) {
            this.settingsData.setThreadsCount(JadxArgs.DEFAULT_THREADS_COUNT);
        }
        if (this.settingsData.getDeobfuscationMinLength() < 0) {
            this.settingsData.setDeobfuscationMinLength(0);
        }
        if (this.settingsData.getDeobfuscationMaxLength() < 0) {
            this.settingsData.setDeobfuscationMaxLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Object object = this.dataWriteSync;
        synchronized (object) {
            this.configAdapter.save(this.settingsData);
        }
    }

    public String exportSettingsString() {
        Gson gson = GsonUtils.defaultGsonBuilder().setExclusionStrategies(new ExclusionStrategy(){

            @Override
            public boolean shouldSkipField(FieldAttributes f15) {
                return f15.getAnnotation(JadxConfigExclude.class) != null || f15.getAnnotation(JadxConfigExcludeExport.class) != null;
            }

            @Override
            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }).create();
        return gson.toJson(this.settingsData);
    }

    public JadxArgs toJadxArgs() {
        return this.settingsData.toJadxArgs();
    }

    public List<String> getFiles() {
        return this.settingsData.getFiles();
    }

    public String getCmdSelectClass() {
        return this.settingsData.getCmdSelectClass();
    }

    public Path getLastOpenFilePath() {
        return this.settingsData.getLastOpenFilePath();
    }

    public void setLastOpenFilePath(Path lastOpenFilePath) {
        this.settingsData.setLastOpenFilePath(lastOpenFilePath);
    }

    public Path getLastSaveProjectPath() {
        return this.settingsData.getLastSaveProjectPath();
    }

    public void setLastSaveProjectPath(Path lastSaveProjectPath) {
        this.settingsData.setLastSaveProjectPath(lastSaveProjectPath);
    }

    public Path getLastSaveFilePath() {
        return this.settingsData.getLastSaveFilePath();
    }

    public void setLastSaveFilePath(Path lastSaveFilePath) {
        this.settingsData.setLastSaveFilePath(lastSaveFilePath);
    }

    public boolean isFlattenPackage() {
        return this.settingsData.isFlattenPackage();
    }

    public void setFlattenPackage(boolean flattenPackage) {
        this.settingsData.setFlattenPackage(flattenPackage);
    }

    public boolean isCheckForUpdates() {
        return this.settingsData.isCheckForUpdates();
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.settingsData.setCheckForUpdates(checkForUpdates);
        this.sync();
    }

    public boolean isDisableTooltipOnHover() {
        return this.settingsData.isDisableTooltipOnHover();
    }

    public void setDisableTooltipOnHover(boolean disableTooltipOnHover) {
        this.settingsData.setDisableTooltipOnHover(disableTooltipOnHover);
    }

    public List<Path> getRecentProjects() {
        return Collections.unmodifiableList(this.settingsData.getRecentProjects());
    }

    public void addRecentProject(@Nullable Path projectPath) {
        if (projectPath == null) {
            return;
        }
        List<Path> recentProjects = this.settingsData.getRecentProjects();
        Path normPath = projectPath.toAbsolutePath().normalize();
        recentProjects.remove(normPath);
        recentProjects.add(0, normPath);
        int count = recentProjects.size();
        if (count > 30) {
            recentProjects.subList(30, count).clear();
        }
    }

    public void removeRecentProject(Path projectPath) {
        List<Path> recentProjects = this.settingsData.getRecentProjects();
        recentProjects.remove(projectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWindowPos(Window window) {
        Object object = this.dataWriteSync;
        synchronized (object) {
            WindowLocation pos = new WindowLocation(window.getClass().getSimpleName(), window.getBounds());
            this.settingsData.getWindowPos().put(pos.getWindowId(), pos);
        }
    }

    public boolean loadWindowPos(Window window) {
        Map<String, WindowLocation> windowPos = this.settingsData.getWindowPos();
        WindowLocation pos = windowPos.get(window.getClass().getSimpleName());
        if (pos == null || pos.getBounds() == null) {
            return false;
        }
        if (!JadxSettings.isAccessibleInAnyScreen(pos)) {
            return false;
        }
        window.setBounds(pos.getBounds());
        if (window instanceof MainWindow) {
            ((JFrame)window).setExtendedState(this.getMainWindowExtendedState());
        }
        return true;
    }

    private static boolean isAccessibleInAnyScreen(WindowLocation pos) {
        Rectangle windowBounds = pos.getBounds();
        for (GraphicsDevice gd5 : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle screenBounds = gd5.getDefaultConfiguration().getBounds();
            if (!screenBounds.intersects(windowBounds)) continue;
            return true;
        }
        LOG.debug("Window saved position was ignored: {}", (Object)pos);
        return false;
    }

    public int getMainWindowExtendedState() {
        return this.settingsData.getMainWindowExtendedState();
    }

    public void setMainWindowExtendedState(int mainWindowExtendedState) {
        this.settingsData.setMainWindowExtendedState(mainWindowExtendedState);
    }

    public boolean isShowHeapUsageBar() {
        return this.settingsData.isShowHeapUsageBar();
    }

    public void setShowHeapUsageBar(boolean showHeapUsageBar) {
        this.settingsData.setShowHeapUsageBar(showHeapUsageBar);
    }

    public boolean isAlwaysSelectOpened() {
        return this.settingsData.isAlwaysSelectOpened();
    }

    public void setAlwaysSelectOpened(boolean alwaysSelectOpened) {
        this.settingsData.setAlwaysSelectOpened(alwaysSelectOpened);
    }

    public boolean isEnablePreviewTab() {
        return this.settingsData.isEnablePreviewTab();
    }

    public void setEnablePreviewTab(boolean enablePreviewTab) {
        this.settingsData.setEnablePreviewTab(enablePreviewTab);
    }

    public boolean isUseAlternativeFileDialog() {
        return this.settingsData.isUseAlternativeFileDialog();
    }

    public void setUseAlternativeFileDialog(boolean useAlternativeFileDialog) {
        this.settingsData.setUseAlternativeFileDialog(useAlternativeFileDialog);
    }

    public String getExcludedPackages() {
        return this.settingsData.getExcludedPackages();
    }

    public void setExcludedPackages(String excludedPackages) {
        this.settingsData.setExcludedPackages(excludedPackages);
    }

    public LangLocale getLangLocale() {
        return this.settingsData.getLangLocale();
    }

    public void setLangLocale(LangLocale langLocale) {
        this.settingsData.setLangLocale(langLocale);
    }

    public boolean isAutoStartJobs() {
        return this.settingsData.isAutoStartJobs();
    }

    public void setAutoStartJobs(boolean autoStartJobs) {
        this.settingsData.setAutoStartJobs(autoStartJobs);
    }

    public ShortcutsWrapper getShortcuts() {
        return this.shortcutsWrapper;
    }

    public int getTreeWidth() {
        return this.settingsData.getTreeWidth();
    }

    public void setTreeWidth(int treeWidth) {
        this.settingsData.setTreeWidth(treeWidth);
    }

    public float getUiZoom() {
        return this.settingsData.getUiZoom();
    }

    public void setUiZoom(float uiZoom) {
        this.settingsData.setUiZoom(uiZoom);
        this.fontSettings.applyUiZoom(uiZoom, this.isApplyUiZoomToFonts());
    }

    public boolean isApplyUiZoomToFonts() {
        return this.settingsData.isApplyUiZoomToFonts();
    }

    public void setApplyUiZoomToFonts(boolean applyUiZoomToFonts) {
        this.settingsData.setApplyUiZoomToFonts(applyUiZoomToFonts);
        this.fontSettings.applyUiZoom(this.getUiZoom(), applyUiZoomToFonts);
    }

    public FontSettings getFontSettings() {
        return this.fontSettings;
    }

    public Font getUiFont() {
        return this.fontSettings.getUiFontAdapter().getEffectiveFont();
    }

    public void setUiFont(Font font) {
        this.fontSettings.getUiFontAdapter().setFont(font);
    }

    public Font getCodeFont() {
        return this.fontSettings.getCodeFontAdapter().getEffectiveFont();
    }

    public void setCodeFont(Font font) {
        this.fontSettings.getCodeFontAdapter().setFont(font);
    }

    public Font getSmaliFont() {
        return this.fontSettings.getSmaliFontAdapter().getEffectiveFont();
    }

    public void setSmaliFont(Font font) {
        this.fontSettings.getSmaliFontAdapter().setFont(font);
    }

    public String getEditorTheme() {
        return this.settingsData.getEditorTheme();
    }

    public void setEditorTheme(String editorTheme) {
        this.settingsData.setEditorTheme(editorTheme);
    }

    public String getLafTheme() {
        return this.settingsData.getLafTheme();
    }

    public void setLafTheme(String lafTheme) {
        this.settingsData.setLafTheme(lafTheme);
    }

    public boolean isCodeAreaLineWrap() {
        return this.settingsData.isCodeAreaLineWrap();
    }

    public void setCodeAreaLineWrap(boolean lineWrap) {
        this.settingsData.setCodeAreaLineWrap(lineWrap);
    }

    public int getSearchResultsPerPage() {
        return this.settingsData.getSearchResultsPerPage();
    }

    public void setSearchResultsPerPage(int searchResultsPerPage) {
        this.settingsData.setSearchResultsPerPage(searchResultsPerPage);
    }

    public boolean isUseAutoSearch() {
        return this.settingsData.isUseAutoSearch();
    }

    public void saveUseAutoSearch(boolean useAutoSearch) {
        this.settingsData.setUseAutoSearch(useAutoSearch);
        this.sync();
    }

    public void saveKeepCommonDialogOpen(boolean keepCommonDialogOpen) {
        this.settingsData.setKeepCommonDialogOpen(keepCommonDialogOpen);
        this.sync();
    }

    public boolean isKeepCommonDialogOpen() {
        return this.settingsData.isKeepCommonDialogOpen();
    }

    public int getMainWindowVerticalSplitterLoc() {
        return this.settingsData.getMainWindowVerticalSplitterLoc();
    }

    public void setMainWindowVerticalSplitterLoc(int location) {
        this.settingsData.setMainWindowVerticalSplitterLoc(location);
    }

    public int getDebuggerStackFrameSplitterLoc() {
        return this.settingsData.getDebuggerStackFrameSplitterLoc();
    }

    public void setDebuggerStackFrameSplitterLoc(int location) {
        this.settingsData.setDebuggerStackFrameSplitterLoc(location);
    }

    public int getDebuggerVarTreeSplitterLoc() {
        return this.settingsData.getDebuggerVarTreeSplitterLoc();
    }

    public void setDebuggerVarTreeSplitterLoc(int location) {
        this.settingsData.setDebuggerVarTreeSplitterLoc(location);
    }

    public String getAdbDialogHost() {
        return this.settingsData.getAdbDialogHost();
    }

    public void setAdbDialogHost(String adbDialogHost) {
        this.settingsData.setAdbDialogHost(adbDialogHost);
    }

    public String getAdbDialogPath() {
        return this.settingsData.getAdbDialogPath();
    }

    public void setAdbDialogPath(String adbDialogPath) {
        this.settingsData.setAdbDialogPath(adbDialogPath);
    }

    public String getAdbDialogPort() {
        return this.settingsData.getAdbDialogPort();
    }

    public void setAdbDialogPort(String adbDialogPort) {
        this.settingsData.setAdbDialogPort(adbDialogPort);
    }

    public CommentsLevel getCommentsLevel() {
        return this.settingsData.getCommentsLevel();
    }

    public void setCommentsLevel(CommentsLevel level) {
        this.settingsData.setCommentsLevel(level);
    }

    public int getTypeUpdatesLimitCount() {
        return this.settingsData.getTypeUpdatesLimitCount();
    }

    public void setTypeUpdatesLimitCount(int typeUpdatesLimitCount) {
        this.settingsData.setTypeUpdatesLimitCount(typeUpdatesLimitCount);
    }

    public LineNumbersMode getLineNumbersMode() {
        return this.settingsData.getLineNumbersMode();
    }

    public void setLineNumbersMode(LineNumbersMode lineNumbersMode) {
        this.settingsData.setLineNumbersMode(lineNumbersMode);
    }

    public CodeCacheMode getCodeCacheMode() {
        return this.settingsData.getCodeCacheMode();
    }

    public void setCodeCacheMode(CodeCacheMode codeCacheMode) {
        this.settingsData.setCodeCacheMode(codeCacheMode);
    }

    public UsageCacheMode getUsageCacheMode() {
        return this.settingsData.getUsageCacheMode();
    }

    public void setUsageCacheMode(UsageCacheMode usageCacheMode) {
        this.settingsData.setUsageCacheMode(usageCacheMode);
    }

    @Nullable
    public String getCacheDir() {
        return this.settingsData.getCacheDir();
    }

    public void setCacheDir(@Nullable String cacheDir) {
        this.settingsData.setCacheDir(cacheDir);
    }

    public boolean isJumpOnDoubleClick() {
        return this.settingsData.isJumpOnDoubleClick();
    }

    public void setJumpOnDoubleClick(boolean jumpOnDoubleClick) {
        this.settingsData.setJumpOnDoubleClick(jumpOnDoubleClick);
    }

    public boolean isDockLogViewer() {
        return this.settingsData.isDockLogViewer();
    }

    public void saveDockLogViewer(boolean dockLogViewer) {
        this.settingsData.setDockLogViewer(dockLogViewer);
        this.sync();
    }

    public boolean isDockQuickTabs() {
        return this.settingsData.isDockQuickTabs();
    }

    public void saveDockQuickTabs(boolean dockQuickTabs) {
        this.settingsData.setDockQuickTabs(dockQuickTabs);
        this.sync();
    }

    public XposedCodegenLanguage getXposedCodegenLanguage() {
        return this.settingsData.getXposedCodegenLanguage();
    }

    public void setXposedCodegenLanguage(XposedCodegenLanguage language) {
        this.settingsData.setXposedCodegenLanguage(language);
    }

    public JadxUpdateChannel getJadxUpdateChannel() {
        return this.settingsData.getJadxUpdateChannel();
    }

    public void setJadxUpdateChannel(JadxUpdateChannel channel) {
        this.settingsData.setJadxUpdateChannel(channel);
    }

    public TabDndGhostType getTabDndGhostType() {
        return this.settingsData.getTabDndGhostType();
    }

    public void setTabDndGhostType(TabDndGhostType tabDndGhostType) {
        this.settingsData.setTabDndGhostType(tabDndGhostType);
    }

    public boolean isRestoreSwitchOverString() {
        return this.settingsData.isRestoreSwitchOverString();
    }

    public void setRestoreSwitchOverString(boolean restoreSwitchOverString) {
        this.settingsData.setRestoreSwitchOverString(restoreSwitchOverString);
    }

    public boolean isRenamePrintable() {
        return this.settingsData.isRenamePrintable();
    }

    public UserRenamesMappingsMode getUserRenamesMappingsMode() {
        return this.settingsData.getUserRenamesMappingsMode();
    }

    public void setUserRenamesMappingsMode(UserRenamesMappingsMode userRenamesMappingsMode) {
        this.settingsData.setUserRenamesMappingsMode(userRenamesMappingsMode);
    }

    public boolean isInlineAnonymousClasses() {
        return this.settingsData.isInlineAnonymousClasses();
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.settingsData.setInlineAnonymousClasses(inlineAnonymousClasses);
    }

    public boolean isRespectBytecodeAccessModifiers() {
        return this.settingsData.isRespectBytecodeAccessModifiers();
    }

    public void setRespectBytecodeAccessModifiers(boolean respectBytecodeAccessModifiers) {
        this.settingsData.setRespectBytecodeAccessModifiers(respectBytecodeAccessModifiers);
    }

    public boolean isRenameCaseSensitive() {
        return this.settingsData.isRenameCaseSensitive();
    }

    public DecompilationMode getDecompilationMode() {
        return this.settingsData.getDecompilationMode();
    }

    public void setDecompilationMode(DecompilationMode decompilationMode) {
        this.settingsData.setDecompilationMode(decompilationMode);
    }

    public boolean isInlineMethods() {
        return this.settingsData.isInlineMethods();
    }

    public void setInlineMethods(boolean inlineMethods) {
        this.settingsData.setInlineMethods(inlineMethods);
    }

    public boolean isFsCaseSensitive() {
        return this.settingsData.isFsCaseSensitive();
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.settingsData.setFsCaseSensitive(fsCaseSensitive);
    }

    public boolean isExtractFinally() {
        return this.settingsData.isExtractFinally();
    }

    public void setExtractFinally(boolean extractFinally) {
        this.settingsData.setExtractFinally(extractFinally);
    }

    public int getSourceNameRepeatLimit() {
        return this.settingsData.getSourceNameRepeatLimit();
    }

    public void setSourceNameRepeatLimit(int sourceNameRepeatLimit) {
        this.settingsData.setSourceNameRepeatLimit(sourceNameRepeatLimit);
    }

    public boolean isRenameValid() {
        return this.settingsData.isRenameValid();
    }

    public boolean isSkipXmlPrettyPrint() {
        return this.settingsData.isSkipXmlPrettyPrint();
    }

    public void setSkipXmlPrettyPrint(boolean skipXmlPrettyPrint) {
        this.settingsData.setSkipXmlPrettyPrint(skipXmlPrettyPrint);
    }

    public UseSourceNameAsClassNameAlias getUseSourceNameAsClassNameAlias() {
        return this.settingsData.getUseSourceNameAsClassNameAlias();
    }

    public void setUseSourceNameAsClassNameAlias(UseSourceNameAsClassNameAlias useSourceNameAsClassNameAlias) {
        this.settingsData.setUseSourceNameAsClassNameAlias(useSourceNameAsClassNameAlias);
    }

    public boolean isShowInconsistentCode() {
        return this.settingsData.isShowInconsistentCode();
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.settingsData.setShowInconsistentCode(showInconsistentCode);
    }

    public boolean isCfgOutput() {
        return this.settingsData.isCfgOutput();
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.settingsData.setCfgOutput(cfgOutput);
    }

    public boolean isEscapeUnicode() {
        return this.settingsData.isEscapeUnicode();
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.settingsData.setEscapeUnicode(escapeUnicode);
    }

    public JadxArgs.UseKotlinMethodsForVarNames getUseKotlinMethodsForVarNames() {
        return this.settingsData.getUseKotlinMethodsForVarNames();
    }

    public void setUseKotlinMethodsForVarNames(JadxArgs.UseKotlinMethodsForVarNames useKotlinMethodsForVarNames) {
        this.settingsData.setUseKotlinMethodsForVarNames(useKotlinMethodsForVarNames);
    }

    public String getDeobfuscationWhitelistStr() {
        return this.settingsData.getDeobfuscationWhitelistStr();
    }

    public void setDeobfuscationWhitelistStr(String deobfuscationWhitelistStr) {
        this.settingsData.setDeobfuscationWhitelistStr(deobfuscationWhitelistStr);
    }

    public String getGeneratedRenamesMappingFile() {
        return this.settingsData.getGeneratedRenamesMappingFile();
    }

    public boolean isRawCfgOutput() {
        return this.settingsData.isRawCfgOutput();
    }

    public void setRawCfgOutput(boolean rawCfgOutput) {
        this.settingsData.setRawCfgOutput(rawCfgOutput);
    }

    public boolean isMoveInnerClasses() {
        return this.settingsData.isMoveInnerClasses();
    }

    public void setMoveInnerClasses(boolean moveInnerClasses) {
        this.settingsData.setMoveInnerClasses(moveInnerClasses);
    }

    public boolean isUseDx() {
        return this.settingsData.isUseDx();
    }

    public void setUseDx(boolean useDx) {
        this.settingsData.setUseDx(useDx);
    }

    public boolean isAddDebugLines() {
        return this.settingsData.isAddDebugLines();
    }

    public boolean isUseHeadersForDetectResourceExtensions() {
        return this.settingsData.isUseHeadersForDetectResourceExtensions();
    }

    public void setUseHeadersForDetectResourceExtensions(boolean useHeadersForDetectResourceExtensions) {
        this.settingsData.setUseHeadersForDetectResourceExtensions(useHeadersForDetectResourceExtensions);
    }

    public Map<String, String> getPluginOptions() {
        return this.settingsData.getPluginOptions();
    }

    public boolean isDeobfuscationOn() {
        return this.settingsData.isDeobfuscationOn();
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.settingsData.setDeobfuscationOn(deobfuscationOn);
    }

    public boolean isReplaceConsts() {
        return this.settingsData.isReplaceConsts();
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.settingsData.setReplaceConsts(replaceConsts);
    }

    public boolean isAllowInlineKotlinLambda() {
        return this.settingsData.isAllowInlineKotlinLambda();
    }

    public void setAllowInlineKotlinLambda(boolean allowInlineKotlinLambda) {
        this.settingsData.setAllowInlineKotlinLambda(allowInlineKotlinLambda);
    }

    public void setDeobfuscationUseSourceNameAsAlias(Boolean deobfuscationUseSourceNameAsAlias) {
        this.settingsData.setDeobfuscationUseSourceNameAsAlias(deobfuscationUseSourceNameAsAlias);
    }

    public void setRenameFlags(Set<JadxArgs.RenameEnum> renameFlags) {
        this.settingsData.setRenameFlags(renameFlags);
    }

    public void updateRenameFlag(JadxArgs.RenameEnum flag, boolean enabled) {
        if (enabled) {
            this.settingsData.getRenameFlags().add(flag);
        } else {
            this.settingsData.getRenameFlags().remove((Object)flag);
        }
    }

    public void setUserRenamesMappingsPath(Path userRenamesMappingsPath) {
        this.settingsData.setUserRenamesMappingsPath(userRenamesMappingsPath);
    }

    public boolean isSkipSources() {
        return this.settingsData.isSkipSources();
    }

    public boolean isDebugInfo() {
        return this.settingsData.isDebugInfo();
    }

    public void setDebugInfo(boolean debugInfo) {
        this.settingsData.setDebugInfo(debugInfo);
    }

    public boolean isSkipResources() {
        return this.settingsData.isSkipResources();
    }

    public void setSkipResources(boolean skipResources) {
        this.settingsData.setSkipResources(skipResources);
    }

    public ResourceNameSource getResourceNameSource() {
        return this.settingsData.getResourceNameSource();
    }

    public void setResourceNameSource(ResourceNameSource resourceNameSource) {
        this.settingsData.setResourceNameSource(resourceNameSource);
    }

    public IntegerFormat getIntegerFormat() {
        return this.settingsData.getIntegerFormat();
    }

    public void setIntegerFormat(IntegerFormat format) {
        this.settingsData.setIntegerFormat(format);
    }

    public boolean isFallbackMode() {
        return this.settingsData.isFallbackMode();
    }

    public boolean isUseImports() {
        return this.settingsData.isUseImports();
    }

    public void setUseImports(boolean useImports) {
        this.settingsData.setUseImports(useImports);
    }

    public int getDeobfuscationMinLength() {
        return this.settingsData.getDeobfuscationMinLength();
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.settingsData.setDeobfuscationMinLength(deobfuscationMinLength);
    }

    public GeneratedRenamesMappingFileMode getGeneratedRenamesMappingFileMode() {
        return this.settingsData.getGeneratedRenamesMappingFileMode();
    }

    public void setGeneratedRenamesMappingFileMode(GeneratedRenamesMappingFileMode generatedRenamesMappingFileMode) {
        this.settingsData.setGeneratedRenamesMappingFileMode(generatedRenamesMappingFileMode);
    }

    public int getDeobfuscationMaxLength() {
        return this.settingsData.getDeobfuscationMaxLength();
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.settingsData.setDeobfuscationMaxLength(deobfuscationMaxLength);
    }

    public int getThreadsCount() {
        return this.settingsData.getThreadsCount();
    }

    public void setThreadsCount(int threadsCount) {
        this.settingsData.setThreadsCount(threadsCount);
    }

    public SaveOptionEnum getSaveOption() {
        return this.settingsData.getSaveOption();
    }

    public void setSaveOption(SaveOptionEnum saveOption) {
        this.settingsData.setSaveOption(saveOption);
    }

    public boolean isSmaliAreaShowBytecode() {
        return this.settingsData.isSmaliAreaShowBytecode();
    }

    public void setSmaliAreaShowBytecode(boolean smaliAreaShowBytecode) {
        this.settingsData.setSmaliAreaShowBytecode(smaliAreaShowBytecode);
    }
}

