/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger.smali;

import jadx.gui.device.debugger.smali.RegisterInfo;

public class SmaliRegister
extends RegisterInfo {
    private final int num;
    private String paramName;
    private final int endOffset;
    private int startOffset;
    private boolean isParam;
    private int runtimeNum;

    public SmaliRegister(int num, int insnCount) {
        this.num = num;
        this.endOffset = insnCount;
        this.startOffset = insnCount;
    }

    public int getRuntimeRegNum() {
        return this.runtimeNum;
    }

    public void setRuntimeRegNum(int runtimeNum) {
        this.runtimeNum = runtimeNum;
    }

    @Override
    public boolean isInitialized(long codeOffset) {
        return codeOffset > (long)this.getStartOffset() && codeOffset < (long)this.getEndOffset();
    }

    protected void setParam(String name) {
        this.paramName = name;
        this.isParam = true;
    }

    protected void setStartOffset(int off) {
        if (off < this.startOffset) {
            this.startOffset = off;
        }
    }

    @Override
    public String getName() {
        return this.paramName != null ? this.paramName : "v" + this.num;
    }

    @Override
    public int getRegNum() {
        return this.num;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public boolean isMarkedAsParameter() {
        return this.isParam;
    }
}

