/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code.disk.adapters;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.cache.code.disk.adapters.DataAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgTypeAdapter
implements DataAdapter<ArgType> {
    public static final ArgTypeAdapter INSTANCE = new ArgTypeAdapter();

    @Override
    public void write(DataOutput out, ArgType value) throws IOException {
        if (value == null) {
            this.writeType(out, Types.NULL);
            return;
        }
        if (!value.isTypeKnown()) {
            this.writeType(out, Types.UNKNOWN);
            return;
        }
        if (value.isPrimitive()) {
            this.writeType(out, Types.PRIMITIVE);
            out.writeByte(value.getPrimitiveType().getShortName().charAt(0));
            return;
        }
        if (value.getOuterType() != null) {
            this.writeType(out, Types.OUTER_GENERIC);
            this.write(out, value.getOuterType());
            this.write(out, value.getInnerType());
            return;
        }
        if (value.getWildcardType() != null) {
            this.writeType(out, Types.WILDCARD);
            ArgType.WildcardBound bound = value.getWildcardBound();
            out.writeByte(bound.getNum());
            if (bound != ArgType.WildcardBound.UNBOUND) {
                this.write(out, value.getWildcardType());
            }
            return;
        }
        if (value.isGeneric()) {
            this.writeType(out, Types.GENERIC);
            out.writeUTF(value.getObject());
            this.writeTypesList(out, value.getGenericTypes());
            return;
        }
        if (value.isGenericType()) {
            this.writeType(out, Types.TYPE_VARIABLE);
            out.writeUTF(value.getObject());
            this.writeTypesList(out, value.getExtendTypes());
            return;
        }
        if (value.isObject()) {
            this.writeType(out, Types.OBJECT);
            out.writeUTF(value.getObject());
            return;
        }
        if (value.isArray()) {
            this.writeType(out, Types.ARRAY);
            out.writeByte(value.getArrayDimension());
            this.write(out, value.getArrayRootElement());
            return;
        }
        throw new JadxRuntimeException("Cannot save type: " + String.valueOf(value) + ", cls: " + String.valueOf(value.getClass()));
    }

    private void writeType(DataOutput out, Types type) throws IOException {
        out.writeByte(type.ordinal());
    }

    @Override
    public ArgType read(DataInput in4) throws IOException {
        byte typeOrdinal = in4.readByte();
        Types type = Types.values()[typeOrdinal];
        switch (type.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                return ArgType.UNKNOWN;
            }
            case 2: {
                char shortName = (char)in4.readByte();
                return ArgType.parse(shortName);
            }
            case 8: {
                ArgType outerType = this.read(in4);
                ArgType innerType = this.read(in4);
                return ArgType.outerGeneric(outerType, innerType);
            }
            case 5: {
                ArgType.WildcardBound bound = ArgType.WildcardBound.getByNum(in4.readByte());
                if (bound == ArgType.WildcardBound.UNBOUND) {
                    return ArgType.WILDCARD;
                }
                ArgType objType = this.read(in4);
                return ArgType.wildcard(objType, bound);
            }
            case 6: {
                String clsType = in4.readUTF();
                return ArgType.generic(clsType, this.readTypesList(in4));
            }
            case 7: {
                String typeVar = in4.readUTF();
                List<ArgType> extendTypes = this.readTypesList(in4);
                return ArgType.genericType(typeVar, extendTypes);
            }
            case 4: {
                return ArgType.object(in4.readUTF());
            }
            case 3: {
                byte dim = in4.readByte();
                ArgType rootType = this.read(in4);
                return ArgType.array(rootType, dim);
            }
        }
        throw new RuntimeException("Unexpected arg type: " + String.valueOf((Object)type));
    }

    private void writeTypesList(DataOutput out, List<ArgType> types) throws IOException {
        out.writeByte(types.size());
        for (ArgType type : types) {
            this.write(out, type);
        }
    }

    private List<ArgType> readTypesList(DataInput in4) throws IOException {
        int size = in4.readByte();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<ArgType> list2 = new ArrayList<ArgType>(size);
        for (int i15 = 0; i15 < size; ++i15) {
            list2.add(this.read(in4));
        }
        return list2;
    }

    private static enum Types {
        NULL,
        UNKNOWN,
        PRIMITIVE,
        ARRAY,
        OBJECT,
        WILDCARD,
        GENERIC,
        TYPE_VARIABLE,
        OUTER_GENERIC;

    }
}

