/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.blocks;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.blocks.BlockSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DFSIteration {
    private final Function<BlockNode, List<BlockNode>> nextFunc;
    private final Deque<BlockNode> queue;
    private final BlockSet visited;

    public DFSIteration(MethodNode mth, BlockNode startBlock, Function<BlockNode, List<BlockNode>> next) {
        this.nextFunc = next;
        this.queue = new ArrayDeque<BlockNode>();
        this.visited = new BlockSet(mth);
        this.queue.addLast(startBlock);
        this.visited.add(startBlock);
    }

    @Nullable
    public BlockNode next() {
        BlockNode current = this.queue.pollLast();
        if (current == null) {
            return null;
        }
        List<BlockNode> nextBlocks = this.nextFunc.apply(current);
        int count = nextBlocks.size();
        for (int i15 = count - 1; i15 >= 0; --i15) {
            BlockNode next = nextBlocks.get(i15);
            if (this.visited.addChecked(next)) continue;
            this.queue.addLast(next);
        }
        return current;
    }
}

