/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.export.gen;

import jadx.api.ResourceFile;
import jadx.core.dex.nodes.RootNode;
import jadx.core.export.OutDirs;
import jadx.core.export.TemplateFile;
import jadx.core.export.gen.GradleGeneratorTools;
import jadx.core.export.gen.IExportGradleGenerator;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SimpleJavaGradleGenerator
implements IExportGradleGenerator {
    private final RootNode root;
    private final File projectDir;
    private final List<ResourceFile> resources;
    private OutDirs outDirs;
    private File appDir;

    public SimpleJavaGradleGenerator(RootNode root, File projectDir, List<ResourceFile> resources) {
        this.root = root;
        this.projectDir = projectDir;
        this.resources = resources;
    }

    @Override
    public void init() {
        this.appDir = new File(this.projectDir, "app");
        File srcOutDir = new File(this.appDir, "src/main/java");
        File resOutDir = new File(this.appDir, "src/main/resources");
        this.outDirs = new OutDirs(srcOutDir, resOutDir);
    }

    @Override
    public void generateFiles() {
        try {
            this.saveSettingsGradle();
            this.saveBuildGradle();
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Failed to generate gradle files", e15);
        }
    }

    private void saveSettingsGradle() throws IOException {
        TemplateFile tmpl = TemplateFile.fromResources("/export/java/settings.gradle.kts.tmpl");
        tmpl.add("projectName", GradleGeneratorTools.guessProjectName(this.root));
        tmpl.save(new File(this.projectDir, "settings.gradle.kts"));
    }

    private void saveBuildGradle() throws IOException {
        TemplateFile tmpl = TemplateFile.fromResources("/export/java/build.gradle.kts.tmpl");
        tmpl.save(new File(this.appDir, "build.gradle.kts"));
    }

    @Override
    public OutDirs getOutDirs() {
        return this.outDirs;
    }
}

