/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BlockNode
extends AttrNode
implements IBlock,
Comparable<BlockNode> {
    private final int cid;
    private int pos;
    private final int startOffset;
    private final List<InsnNode> instructions = new ArrayList<InsnNode>(2);
    private List<BlockNode> predecessors = new ArrayList<BlockNode>(1);
    private List<BlockNode> successors = new ArrayList<BlockNode>(1);
    private List<BlockNode> cleanSuccessors;
    private BitSet doms = EmptyBitSet.EMPTY;
    private BitSet postDoms = EmptyBitSet.EMPTY;
    private BitSet domFrontier;
    private BlockNode idom;
    private BlockNode iPostDom;
    private List<BlockNode> dominatesOn = new ArrayList<BlockNode>(3);

    public BlockNode(int cid, int pos, int offset) {
        this.cid = cid;
        this.pos = pos;
        this.startOffset = offset;
    }

    public int getCId() {
        return this.cid;
    }

    void setPos(int id5) {
        this.pos = id5;
    }

    @Deprecated
    public int getId() {
        return this.pos;
    }

    public int getPos() {
        return this.pos;
    }

    public List<BlockNode> getPredecessors() {
        return this.predecessors;
    }

    public List<BlockNode> getSuccessors() {
        return this.successors;
    }

    public List<BlockNode> getCleanSuccessors() {
        return this.cleanSuccessors;
    }

    public void updateCleanSuccessors() {
        this.cleanSuccessors = BlockNode.cleanSuccessors(this);
    }

    public static void updateBlockPositions(List<BlockNode> blocks) {
        int count = blocks.size();
        for (int i15 = 0; i15 < count; ++i15) {
            blocks.get(i15).setPos(i15);
        }
    }

    public void lock() {
        try {
            List<BlockNode> successorsList = this.successors;
            this.successors = Utils.lockList(successorsList);
            this.cleanSuccessors = successorsList == this.cleanSuccessors ? this.successors : Utils.lockList(this.cleanSuccessors);
            this.predecessors = Utils.lockList(this.predecessors);
            this.dominatesOn = Utils.lockList(this.dominatesOn);
            if (this.domFrontier == null) {
                throw new JadxRuntimeException("Dominance frontier not set for block: " + String.valueOf(this));
            }
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Failed to lock block: " + String.valueOf(this), e15);
        }
    }

    private static List<BlockNode> cleanSuccessors(BlockNode block) {
        List<BlockNode> sucList = block.getSuccessors();
        if (sucList.isEmpty()) {
            return sucList;
        }
        ArrayList<BlockNode> toRemove = new ArrayList<BlockNode>(sucList.size());
        for (BlockNode b15 : sucList) {
            if (!BlockUtils.isExceptionHandlerPath(b15)) continue;
            toRemove.add(b15);
        }
        if (block.contains(AFlag.LOOP_END)) {
            List loops = block.getAll(AType.LOOP);
            for (LoopInfo loop : loops) {
                toRemove.add(loop.getStart());
            }
        }
        if (toRemove.isEmpty()) {
            return sucList;
        }
        ArrayList<BlockNode> result = new ArrayList<BlockNode>(sucList);
        result.removeAll(toRemove);
        return result;
    }

    @Override
    public List<InsnNode> getInstructions() {
        return this.instructions;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public boolean isDominator(BlockNode block) {
        return this.doms.get(block.getPos());
    }

    public BitSet getDoms() {
        return this.doms;
    }

    public void setDoms(BitSet doms) {
        this.doms = doms;
    }

    public BitSet getPostDoms() {
        return this.postDoms;
    }

    public void setPostDoms(BitSet postDoms) {
        this.postDoms = postDoms;
    }

    public BitSet getDomFrontier() {
        return this.domFrontier;
    }

    public void setDomFrontier(BitSet domFrontier) {
        this.domFrontier = domFrontier;
    }

    public BlockNode getIDom() {
        return this.idom;
    }

    public void setIDom(BlockNode idom) {
        this.idom = idom;
    }

    public BlockNode getIPostDom() {
        return this.iPostDom;
    }

    public void setIPostDom(BlockNode iPostDom) {
        this.iPostDom = iPostDom;
    }

    public List<BlockNode> getDominatesOn() {
        return this.dominatesOn;
    }

    public void addDominatesOn(BlockNode block) {
        this.dominatesOn.add(block);
    }

    public boolean isSynthetic() {
        return this.contains(AFlag.SYNTHETIC);
    }

    public boolean isReturnBlock() {
        return this.contains(AFlag.RETURN);
    }

    public boolean isMthExitBlock() {
        return this.contains(AFlag.MTH_EXIT_BLOCK);
    }

    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public int hashCode() {
        return this.cid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockNode)) {
            return false;
        }
        BlockNode other = (BlockNode)obj;
        return this.cid == other.cid;
    }

    @Override
    public int compareTo(@NotNull BlockNode o15) {
        return Integer.compare(this.cid, o15.cid);
    }

    @Override
    public String baseString() {
        return Integer.toString(this.cid);
    }

    public String toString() {
        return "B:" + this.cid + ":" + InsnUtils.formatOffset(this.startOffset);
    }
}

