/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class NameMapper {
    public static final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern VALID_JAVA_FULL_IDENTIFIER = Pattern.compile("(" + String.valueOf(VALID_JAVA_IDENTIFIER) + "\\.)*" + String.valueOf(VALID_JAVA_IDENTIFIER));
    private static final Set<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("_", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public static boolean isReserved(String str) {
        return RESERVED_NAMES.contains(str);
    }

    public static boolean isValidIdentifier(String str) {
        return StringUtils.notEmpty(str) && !NameMapper.isReserved(str) && VALID_JAVA_IDENTIFIER.matcher(str).matches();
    }

    public static boolean isValidFullIdentifier(String str) {
        return StringUtils.notEmpty(str) && !NameMapper.isReserved(str) && VALID_JAVA_FULL_IDENTIFIER.matcher(str).matches();
    }

    public static boolean isValidAndPrintable(String str) {
        return NameMapper.isValidIdentifier(str) && NameMapper.isAllCharsPrintable(str);
    }

    public static boolean isValidIdentifierStart(int codePoint) {
        return Character.isJavaIdentifierStart(codePoint);
    }

    public static boolean isValidIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierPart(codePoint);
    }

    public static boolean isPrintableChar(char c15) {
        return ' ' <= c15 && c15 <= '~';
    }

    public static boolean isPrintableAsciiCodePoint(int c15) {
        return 32 <= c15 && c15 <= 126;
    }

    public static boolean isPrintableCodePoint(int codePoint) {
        if (Character.isISOControl(codePoint)) {
            return false;
        }
        if (Character.isWhitespace(codePoint)) {
            return codePoint == 32;
        }
        switch (Character.getType(codePoint)) {
            case 0: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return false;
            }
        }
        return true;
    }

    public static boolean isAllCharsPrintable(String str) {
        int codePoint;
        int len = str.length();
        for (int offset = 0; offset < len; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            if (NameMapper.isPrintableAsciiCodePoint(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static String removeInvalidCharsMiddle(String name) {
        if (NameMapper.isValidIdentifier(name) && NameMapper.isAllCharsPrintable(name)) {
            return name;
        }
        int len = name.length();
        StringBuilder sb5 = new StringBuilder(len);
        StringUtils.visitCodePoints(name, codePoint -> {
            if (NameMapper.isPrintableAsciiCodePoint(codePoint) && NameMapper.isValidIdentifierPart(codePoint)) {
                sb5.appendCodePoint(codePoint);
            }
        });
        return sb5.toString();
    }

    public static String removeInvalidChars(String name, String prefix) {
        int codePoint;
        String result = NameMapper.removeInvalidCharsMiddle(name);
        if (!result.isEmpty() && !NameMapper.isValidIdentifierStart(codePoint = result.codePointAt(0))) {
            return prefix + result;
        }
        return result;
    }

    public static String removeNonPrintableCharacters(String name) {
        StringBuilder sb5 = new StringBuilder(name.length());
        StringUtils.visitCodePoints(name, codePoint -> {
            if (NameMapper.isPrintableAsciiCodePoint(codePoint)) {
                sb5.appendCodePoint(codePoint);
            }
        });
        return sb5.toString();
    }

    private NameMapper() {
    }
}

