/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ClspMethod
implements IMethodDetails,
Comparable<ClspMethod> {
    private final MethodInfo methodInfo;
    private final List<ArgType> argTypes;
    private final ArgType returnType;
    private final List<ArgType> typeParameters;
    private final List<ArgType> throwList;
    private final int accFlags;

    public ClspMethod(MethodInfo methodInfo, List<ArgType> argTypes, ArgType returnType, List<ArgType> typeParameters, List<ArgType> throwList, int accFlags) {
        this.methodInfo = methodInfo;
        this.argTypes = argTypes;
        this.returnType = returnType;
        this.typeParameters = typeParameters;
        this.throwList = throwList;
        this.accFlags = accFlags;
    }

    @Override
    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public ArgType getReturnType() {
        return this.returnType;
    }

    @Override
    public List<ArgType> getArgTypes() {
        return this.argTypes;
    }

    public boolean containsGenericArgs() {
        return !Objects.equals(this.argTypes, this.methodInfo.getArgumentsTypes());
    }

    public int getArgsCount() {
        return this.argTypes.size();
    }

    @Override
    public List<ArgType> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public List<ArgType> getThrows() {
        return this.throwList;
    }

    @Override
    public boolean isVarArg() {
        return (this.accFlags & 0x80) != 0;
    }

    @Override
    public int getRawAccessFlags() {
        return this.accFlags;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof ClspMethod)) {
            return false;
        }
        ClspMethod other = (ClspMethod)o15;
        return this.methodInfo.equals(other.methodInfo);
    }

    public int hashCode() {
        return this.methodInfo.hashCode();
    }

    @Override
    public int compareTo(@NotNull ClspMethod other) {
        return this.methodInfo.compareTo(other.methodInfo);
    }

    @Override
    public String toAttrString() {
        return IMethodDetails.super.toAttrString() + " (c)";
    }

    public String toString() {
        List<ArgType> throwsList;
        StringBuilder sb5 = new StringBuilder();
        sb5.append("ClspMth{");
        if (Utils.notEmpty(this.getTypeParameters())) {
            sb5.append('<');
            sb5.append(Utils.listToString(this.getTypeParameters()));
            sb5.append("> ");
        }
        sb5.append(this.getMethodInfo().getFullName());
        sb5.append('(');
        sb5.append(Utils.listToString(this.getArgTypes()));
        sb5.append("):");
        sb5.append(this.getReturnType());
        if (this.isVarArg()) {
            sb5.append(" VARARG");
        }
        if (Utils.notEmpty(throwsList = this.getThrows())) {
            sb5.append(" throws ").append(Utils.listToString(throwsList));
        }
        sb5.append('}');
        return sb5.toString();
    }
}

