/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.EndConsumerHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public abstract class DisposableSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    final AtomicReference<Subscription> upstream = new AtomicReference();

    @Override
    public final void onSubscribe(Subscription s15) {
        if (EndConsumerHelper.setOnce(this.upstream, s15, this.getClass())) {
            this.onStart();
        }
    }

    protected void onStart() {
        this.upstream.get().request(Long.MAX_VALUE);
    }

    protected final void request(long n15) {
        this.upstream.get().request(n15);
    }

    protected final void cancel() {
        this.dispose();
    }

    @Override
    public final boolean isDisposed() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public final void dispose() {
        SubscriptionHelper.cancel(this.upstream);
    }
}

