/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplaySubject<T>
extends Subject<T> {
    final ReplayBuffer<T> buffer;
    final AtomicReference<ReplayDisposable<T>[]> observers;
    static final ReplayDisposable[] EMPTY = new ReplayDisposable[0];
    static final ReplayDisposable[] TERMINATED = new ReplayDisposable[0];
    boolean done;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> create() {
        return new ReplaySubject(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new ReplaySubject(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithSize(int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        return new ReplaySubject(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplaySubject<T> createUnbounded() {
        return new ReplaySubject(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithTime(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithTimeAndSize(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplaySubject(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.observers = new AtomicReference<ReplayDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ReplayDisposable<? super T> rs4 = new ReplayDisposable<T>(observer, this);
        observer.onSubscribe(rs4);
        if (this.add(rs4) && rs4.cancelled) {
            this.remove(rs4);
            return;
        }
        this.buffer.replay(rs4);
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.done) {
            d15.dispose();
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b15 = this.buffer;
        b15.add(t15);
        for (ReplayDisposable<T> rs4 : this.observers.get()) {
            b15.replay(rs4);
        }
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        Object o15 = NotificationLite.error(t15);
        ReplayBuffer<T> b15 = this.buffer;
        b15.addFinal(o15);
        for (ReplayDisposable<T> rs4 : this.terminate(o15)) {
            b15.replay(rs4);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o15 = NotificationLite.complete();
        ReplayBuffer<T> b15 = this.buffer;
        b15.addFinal(o15);
        for (ReplayDisposable<T> rs4 : this.terminate(o15)) {
            b15.replay(rs4);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    @CheckReturnValue
    int observerCount() {
        return this.observers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        Object o15 = this.buffer.get();
        if (NotificationLite.isError(o15)) {
            return NotificationLite.getError(o15);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        return this.buffer.getValue();
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    @CheckReturnValue
    public Object[] getValues() {
        Object[] a15 = EMPTY_ARRAY;
        Object[] b15 = this.getValues(a15);
        if (b15 == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b15;
    }

    @CheckReturnValue
    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        Object o15 = this.buffer.get();
        return NotificationLite.isComplete(o15);
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        Object o15 = this.buffer.get();
        return NotificationLite.isError(o15);
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    @CheckReturnValue
    int size() {
        return this.buffer.size();
    }

    boolean add(ReplayDisposable<T> rs4) {
        ReplayDisposable[] b15;
        ReplayDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = a15.length;
            b15 = new ReplayDisposable[len + 1];
            System.arraycopy(a15, 0, b15, 0, len);
            b15[len] = rs4;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(ReplayDisposable<T> rs4) {
        ReplayDisposable[] b15;
        ReplayDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED || a15 == EMPTY) {
                return;
            }
            int len = a15.length;
            int j15 = -1;
            for (int i15 = 0; i15 < len; ++i15) {
                if (a15[i15] != rs4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (len == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new ReplayDisposable[len - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, len - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    ReplayDisposable<T>[] terminate(Object terminalValue) {
        this.buffer.compareAndSet(null, terminalValue);
        return this.observers.getAndSet(TERMINATED);
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -8056260896137901749L;
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<Object> head;
        TimedNode<Object> tail;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h15 = new TimedNode<Object>(null, 0L);
            this.tail = h15;
            this.head = h15;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<Object> h15 = this.head;
                this.head = (TimedNode)h15.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h16 = this.head;
            while (true) {
                if (this.size <= 1) {
                    this.head = h16;
                    break;
                }
                TimedNode next = (TimedNode)h16.get();
                if (next.time > limit) {
                    this.head = h16;
                    break;
                }
                h16 = next;
                --this.size;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h15 = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h15.get()).get() == null) {
                    if (h15.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h15.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h15;
                    break;
                }
                if (next.time > limit) {
                    if (h15.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h15.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h15;
                    break;
                }
                h15 = next;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n15 = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<Object> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.set(n15);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            TimedNode<Object> n15 = new TimedNode<Object>(notificationLite, Long.MAX_VALUE);
            TimedNode<Object> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.lazySet(n15);
            this.trimFinal();
        }

        @Override
        public void trimHead() {
            TimedNode<Object> h15 = this.head;
            if (h15.value != null) {
                TimedNode<Object> n15 = new TimedNode<Object>(null, 0L);
                n15.lazySet(h15.get());
                this.head = n15;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode prev = null;
            TimedNode h15 = this.head;
            while ((next = (TimedNode)h15.get()) != null) {
                prev = h15;
                h15 = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h15.time < limit) {
                return null;
            }
            Object v15 = h15.value;
            if (v15 == null) {
                return null;
            }
            if (NotificationLite.isComplete(v15) || NotificationLite.isError(v15)) {
                return prev.value;
            }
            return v15;
        }

        TimedNode<Object> getHead() {
            long ts4;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts4 = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h15 = this.getHead();
            int s15 = this.size(h15);
            if (s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s15) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
                }
                for (int i15 = 0; i15 != s15; ++i15) {
                    TimedNode next = (TimedNode)h15.get();
                    array[i15] = next.value;
                    h15 = next;
                }
                if (array.length > s15) {
                    array[s15] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs4) {
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a15 = rs4.downstream;
            TimedNode index = (TimedNode)rs4.index;
            if (index == null) {
                index = this.getHead();
            }
            while (true) {
                if (rs4.cancelled) {
                    rs4.index = null;
                    return;
                }
                TimedNode n15 = (TimedNode)index.get();
                if (n15 != null) {
                    Object o15 = n15.value;
                    if (NotificationLite.isComplete(o15)) {
                        a15.onComplete();
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    if (NotificationLite.isError(o15)) {
                        a15.onError(NotificationLite.getError(o15));
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    a15.onNext(o15);
                    index = n15;
                    continue;
                }
                rs4.index = index;
                if ((missed = rs4.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<Object> h15) {
            int s15;
            for (s15 = 0; s15 != Integer.MAX_VALUE; ++s15) {
                TimedNode next = (TimedNode)h15.get();
                if (next == null) {
                    Object o15 = h15.value;
                    if (!NotificationLite.isComplete(o15) && !NotificationLite.isError(o15)) break;
                    --s15;
                    break;
                }
                h15 = next;
            }
            return s15;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 1107649250281456395L;
        final int maxSize;
        int size;
        volatile Node<Object> head;
        Node<Object> tail;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = maxSize;
            Node<Object> h15 = new Node<Object>(null);
            this.tail = h15;
            this.head = h15;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<Object> h15 = this.head;
                this.head = (Node)h15.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n15 = new Node<T>(value);
            Node<Object> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.set(n15);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            Node<Object> n15 = new Node<Object>(notificationLite);
            Node<Object> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.lazySet(n15);
            this.trimHead();
        }

        @Override
        public void trimHead() {
            Node<Object> h15 = this.head;
            if (h15.value != null) {
                Node<Object> n15 = new Node<Object>(null);
                n15.lazySet(h15.get());
                this.head = n15;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            Node next;
            Node prev = null;
            Node h15 = this.head;
            while ((next = (Node)h15.get()) != null) {
                prev = h15;
                h15 = next;
            }
            Object v15 = h15.value;
            if (v15 == null) {
                return null;
            }
            if (NotificationLite.isComplete(v15) || NotificationLite.isError(v15)) {
                return prev.value;
            }
            return v15;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h15 = this.head;
            int s15 = this.size();
            if (s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s15) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
                }
                for (int i15 = 0; i15 != s15; ++i15) {
                    Node next = (Node)h15.get();
                    array[i15] = next.value;
                    h15 = next;
                }
                if (array.length > s15) {
                    array[s15] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs4) {
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a15 = rs4.downstream;
            Node index = (Node)rs4.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs4.cancelled) {
                    rs4.index = null;
                    return;
                }
                Node n15 = (Node)index.get();
                if (n15 != null) {
                    Object o15 = n15.value;
                    if (NotificationLite.isComplete(o15)) {
                        a15.onComplete();
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    if (NotificationLite.isError(o15)) {
                        a15.onError(NotificationLite.getError(o15));
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    a15.onNext(o15);
                    index = n15;
                    continue;
                }
                if (index.get() != null) continue;
                rs4.index = index;
                if ((missed = rs4.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s15;
            Node h15 = this.head;
            for (s15 = 0; s15 != Integer.MAX_VALUE; ++s15) {
                Node next = (Node)h15.get();
                if (next == null) {
                    Object o15 = h15.value;
                    if (!NotificationLite.isComplete(o15) && !NotificationLite.isError(o15)) break;
                    --s15;
                    break;
                }
                h15 = next;
            }
            return s15;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -733876083048047795L;
        final List<Object> buffer;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<Object>(capacityHint);
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void addFinal(Object notificationLite) {
            this.buffer.add(notificationLite);
            this.trimHead();
            ++this.size;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s15 = this.size;
            if (s15 != 0) {
                List<Object> b15 = this.buffer;
                Object o15 = b15.get(s15 - 1);
                if (NotificationLite.isComplete(o15) || NotificationLite.isError(o15)) {
                    if (s15 == 1) {
                        return null;
                    }
                    return (T)b15.get(s15 - 2);
                }
                return (T)o15;
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s15 = this.size;
            if (s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<Object> b15 = this.buffer;
            Object o15 = b15.get(s15 - 1);
            if ((NotificationLite.isComplete(o15) || NotificationLite.isError(o15)) && --s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s15) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
            }
            for (int i15 = 0; i15 < s15; ++i15) {
                array[i15] = b15.get(i15);
            }
            if (array.length > s15) {
                array[s15] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs4) {
            int index;
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<Object> b15 = this.buffer;
            Observer<Object> a15 = rs4.downstream;
            Integer indexObject = (Integer)rs4.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs4.index = 0;
            }
            while (true) {
                if (rs4.cancelled) {
                    rs4.index = null;
                    return;
                }
                int s15 = this.size;
                while (s15 != index) {
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    Object o15 = b15.get(index);
                    if (NotificationLite.isComplete(o15)) {
                        a15.onComplete();
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    if (NotificationLite.isError(o15)) {
                        a15.onError(NotificationLite.getError(o15));
                        rs4.index = null;
                        rs4.cancelled = true;
                        return;
                    }
                    a15.onNext(o15);
                    ++index;
                }
                if (index != this.size) continue;
                rs4.index = index;
                if ((missed = rs4.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s15 = this.size;
            if (s15 != 0) {
                Object o15 = this.buffer.get(s15 - 1);
                if (NotificationLite.isComplete(o15) || NotificationLite.isError(o15)) {
                    return s15 - 1;
                }
                return s15;
            }
            return 0;
        }
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 466549804534799122L;
        final Observer<? super T> downstream;
        final ReplaySubject<T> state;
        Object index;
        volatile boolean cancelled;

        ReplayDisposable(Observer<? super T> actual, ReplaySubject<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void addFinal(Object var1);

        public void replay(ReplayDisposable<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public Object get();

        public boolean compareAndSet(Object var1, Object var2);

        public void trimHead();
    }
}

