/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.observers.BaseTestConsumer;
import java.util.concurrent.atomic.AtomicReference;

public class TestObserver<T>
extends BaseTestConsumer<T, TestObserver<T>>
implements Observer<T>,
Disposable,
MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver {
    private final Observer<? super T> downstream;
    private final AtomicReference<Disposable> upstream = new AtomicReference();

    @NonNull
    public static <T> TestObserver<T> create() {
        return new TestObserver<T>();
    }

    @NonNull
    public static <T> TestObserver<T> create(@NonNull Observer<? super T> delegate2) {
        return new TestObserver<T>(delegate2);
    }

    public TestObserver() {
        this(EmptyObserver.INSTANCE);
    }

    public TestObserver(@NonNull Observer<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        this.lastThread = Thread.currentThread();
        if (d15 == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.upstream.compareAndSet(null, d15)) {
            d15.dispose();
            if (this.upstream.get() != DisposableHelper.DISPOSED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + d15));
            }
            return;
        }
        this.downstream.onSubscribe(d15);
    }

    @Override
    public void onNext(@NonNull T t15) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        this.values.add(t15);
        if (t15 == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.downstream.onNext(t15);
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            if (t15 == null) {
                this.errors.add(new NullPointerException("onError received a null Throwable"));
            } else {
                this.errors.add(t15);
            }
            this.downstream.onError(t15);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.downstream.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public final void dispose() {
        DisposableHelper.dispose(this.upstream);
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed(this.upstream.get());
    }

    public final boolean hasSubscription() {
        return this.upstream.get() != null;
    }

    @Override
    @NonNull
    protected final TestObserver<T> assertSubscribed() {
        if (this.upstream.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    @Override
    public void onSuccess(@NonNull T value) {
        this.onNext(value);
        this.onComplete();
    }

    static enum EmptyObserver implements Observer<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Disposable d15) {
        }

        @Override
        public void onNext(Object t15) {
        }

        @Override
        public void onError(Throwable t15) {
        }

        @Override
        public void onComplete() {
        }
    }
}

