/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.internal.util.Pow2;

public final class OpenHashSet<T> {
    private static final int INT_PHI = -1640531527;
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public OpenHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int c15 = Pow2.roundToPowerOfTwo(capacity);
        this.mask = c15 - 1;
        this.maxSize = (int)(loadFactor * (float)c15);
        this.keys = new Object[c15];
    }

    public boolean add(T value) {
        T[] a15 = this.keys;
        int m15 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m15;
        T curr = a15[pos];
        if (curr != null) {
            if (curr.equals(value)) {
                return false;
            }
            while ((curr = a15[pos = pos + 1 & m15]) != null) {
                if (!curr.equals(value)) continue;
                return false;
            }
        }
        a15[pos] = value;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(T value) {
        T[] a15 = this.keys;
        int m15 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m15;
        T curr = a15[pos];
        if (curr == null) {
            return false;
        }
        if (curr.equals(value)) {
            return this.removeEntry(pos, a15, m15);
        }
        do {
            if ((curr = a15[pos = pos + 1 & m15]) != null) continue;
            return false;
        } while (!curr.equals(value));
        return this.removeEntry(pos, a15, m15);
    }

    boolean removeEntry(int pos, T[] a15, int m15) {
        --this.size;
        while (true) {
            T curr;
            int last = pos;
            pos = pos + 1 & m15;
            while (true) {
                if ((curr = a15[pos]) == null) {
                    a15[last] = null;
                    return true;
                }
                int slot = OpenHashSet.mix(curr.hashCode()) & m15;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & m15;
            }
            a15[last] = curr;
        }
    }

    void rehash() {
        T[] a15 = this.keys;
        int i15 = a15.length;
        int newCap = i15 << 1;
        int m15 = newCap - 1;
        Object[] b15 = new Object[newCap];
        int j15 = this.size;
        while (j15-- != 0) {
            while (a15[--i15] == null) {
            }
            int pos = OpenHashSet.mix(a15[i15].hashCode()) & m15;
            if (b15[pos] != null) {
                while (b15[pos = pos + 1 & m15] != null) {
                }
            }
            b15[pos] = a15[i15];
        }
        this.mask = m15;
        this.maxSize = (int)((float)newCap * this.loadFactor);
        this.keys = b15;
    }

    static int mix(int x15) {
        int h15 = x15 * -1640531527;
        return h15 ^ h15 >>> 16;
    }

    public Object[] keys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }
}

