/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import java.util.concurrent.TimeUnit;

public final class SingleDelay<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public SingleDelay(SingleSource<? extends T> source, long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        this.source = source;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SequentialDisposable sd5 = new SequentialDisposable();
        observer.onSubscribe(sd5);
        this.source.subscribe(new Delay(sd5, observer));
    }

    final class Delay
    implements SingleObserver<T> {
        private final SequentialDisposable sd;
        final SingleObserver<? super T> downstream;

        Delay(SequentialDisposable sd5, SingleObserver<? super T> observer) {
            this.sd = sd5;
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.sd.replace(d15);
        }

        @Override
        public void onSuccess(T value) {
            this.sd.replace(SingleDelay.this.scheduler.scheduleDirect(new OnSuccess(value), SingleDelay.this.time, SingleDelay.this.unit));
        }

        @Override
        public void onError(Throwable e15) {
            this.sd.replace(SingleDelay.this.scheduler.scheduleDirect(new OnError(e15), SingleDelay.this.delayError ? SingleDelay.this.time : 0L, SingleDelay.this.unit));
        }

        final class OnError
        implements Runnable {
            private final Throwable e;

            OnError(Throwable e15) {
                this.e = e15;
            }

            @Override
            public void run() {
                Delay.this.downstream.onError(this.e);
            }
        }

        final class OnSuccess
        implements Runnable {
            private final T value;

            OnSuccess(T value) {
                this.value = value;
            }

            @Override
            public void run() {
                Delay.this.downstream.onSuccess(this.value);
            }
        }
    }
}

