/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableReduceMaybe<T>
extends Maybe<T> {
    final ObservableSource<T> source;
    final BiFunction<T, T, T> reducer;

    public ObservableReduceMaybe(ObservableSource<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new ReduceObserver<T>(observer, this.reducer));
    }

    static final class ReduceObserver<T>
    implements Observer<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final BiFunction<T, T, T> reducer;
        boolean done;
        T value;
        Disposable upstream;

        ReduceObserver(MaybeObserver<? super T> observer, BiFunction<T, T, T> reducer) {
            this.downstream = observer;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (!this.done) {
                T v15 = this.value;
                if (v15 == null) {
                    this.value = value;
                } else {
                    try {
                        this.value = Objects.requireNonNull(this.reducer.apply(v15, value), "The reducer returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.upstream.dispose();
                        this.onError(ex4);
                    }
                }
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.done) {
                RxJavaPlugins.onError(e15);
                return;
            }
            this.done = true;
            this.value = null;
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v15 = this.value;
            this.value = null;
            if (v15 != null) {
                this.downstream.onSuccess(v15);
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

