/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<PublishConnection<T>> current;

    public ObservablePublish(ObservableSource<T> source) {
        this.source = source;
        this.current = new AtomicReference();
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.current.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
        if (doConnect) {
            this.source.subscribe(conn);
        }
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        PublishConnection<Object> conn;
        while ((conn = this.current.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerDisposable<T> inner = new InnerDisposable<T>(observer, conn);
        observer.onSubscribe(inner);
        if (conn.add(inner)) {
            if (inner.isDisposed()) {
                conn.remove(inner);
            }
            return;
        }
        Throwable error = conn.error;
        if (error != null) {
            observer.onError(error);
        } else {
            observer.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.current.get();
        if (conn != null && conn.isDisposed()) {
            this.current.compareAndSet(conn, null);
        }
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    static final class InnerDisposable<T>
    extends AtomicReference<PublishConnection<T>>
    implements Disposable {
        private static final long serialVersionUID = 7463222674719692880L;
        final Observer<? super T> downstream;

        InnerDisposable(Observer<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            PublishConnection p15 = this.getAndSet(null);
            if (p15 != null) {
                p15.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    static final class PublishConnection<T>
    extends AtomicReference<InnerDisposable<T>[]>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3251430252873581268L;
        final AtomicBoolean connect = new AtomicBoolean();
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<Disposable> upstream;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        Throwable error;

        PublishConnection(AtomicReference<PublishConnection<T>> current) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.lazySet(EMPTY);
        }

        @Override
        public void dispose() {
            this.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            DisposableHelper.dispose(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this.upstream, d15);
        }

        @Override
        public void onNext(T t15) {
            for (InnerDisposable inner : (InnerDisposable[])this.get()) {
                inner.downstream.onNext(t15);
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.upstream.get() != DisposableHelper.DISPOSED) {
                this.error = e15;
                this.upstream.lazySet(DisposableHelper.DISPOSED);
                for (InnerDisposable inner : this.getAndSet(TERMINATED)) {
                    inner.downstream.onError(e15);
                }
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            this.upstream.lazySet(DisposableHelper.DISPOSED);
            for (InnerDisposable inner : this.getAndSet(TERMINATED)) {
                inner.downstream.onComplete();
            }
        }

        public boolean add(InnerDisposable<T> inner) {
            InnerDisposable[] b15;
            InnerDisposable[] a15;
            do {
                if ((a15 = (InnerDisposable[])this.get()) == TERMINATED) {
                    return false;
                }
                int n15 = a15.length;
                b15 = new InnerDisposable[n15 + 1];
                System.arraycopy(a15, 0, b15, 0, n15);
                b15[n15] = inner;
            } while (!this.compareAndSet(a15, b15));
            return true;
        }

        public void remove(InnerDisposable<T> inner) {
            InnerDisposable[] b15;
            InnerDisposable[] a15;
            do {
                int n15;
                if ((n15 = (a15 = (InnerDisposable[])this.get()).length) == 0) {
                    return;
                }
                int j15 = -1;
                for (int i15 = 0; i15 < n15; ++i15) {
                    if (a15[i15] != inner) continue;
                    j15 = i15;
                    break;
                }
                if (j15 < 0) {
                    return;
                }
                b15 = EMPTY;
                if (n15 == 1) continue;
                b15 = new InnerDisposable[n15 - 1];
                System.arraycopy(a15, 0, b15, 0, j15);
                System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
            } while (!this.compareAndSet(a15, b15));
        }
    }
}

