/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMaterialize<T>
extends AbstractObservableWithUpstream<T, Notification<T>> {
    public ObservableMaterialize(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super Notification<T>> t15) {
        this.source.subscribe(new MaterializeObserver(t15));
    }

    static final class MaterializeObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super Notification<T>> downstream;
        Disposable upstream;

        MaterializeObserver(Observer<? super Notification<T>> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(Notification.createOnNext(t15));
        }

        @Override
        public void onError(Throwable t15) {
            Notification v15 = Notification.createOnError(t15);
            this.downstream.onNext(v15);
            this.downstream.onComplete();
        }

        @Override
        public void onComplete() {
            Notification v15 = Notification.createOnComplete();
            this.downstream.onNext(v15);
            this.downstream.onComplete();
        }
    }
}

