/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableElementAt;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;

public final class ObservableElementAtSingle<T>
extends Single<T>
implements FuseToObservable<T> {
    final ObservableSource<T> source;
    final long index;
    final T defaultValue;

    public ObservableElementAtSingle(ObservableSource<T> source, long index, T defaultValue) {
        this.source = source;
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    public void subscribeActual(SingleObserver<? super T> t15) {
        this.source.subscribe(new ElementAtObserver<T>(t15, this.index, this.defaultValue));
    }

    @Override
    public Observable<T> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableElementAt<T>(this.source, this.index, this.defaultValue, true));
    }

    static final class ElementAtObserver<T>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super T> downstream;
        final long index;
        final T defaultValue;
        Disposable upstream;
        long count;
        boolean done;

        ElementAtObserver(SingleObserver<? super T> actual, long index, T defaultValue) {
            this.downstream = actual;
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            long c15 = this.count;
            if (c15 == this.index) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onSuccess(t15);
                return;
            }
            this.count = c15 + 1L;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                T v15 = this.defaultValue;
                if (v15 != null) {
                    this.downstream.onSuccess(v15);
                } else {
                    this.downstream.onError(new NoSuchElementException());
                }
            }
        }
    }
}

