/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;

public final class ObservableDelay<T>
extends AbstractObservableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public ObservableDelay(ObservableSource<T> source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        Observer<? super T> observer = this.delayError ? t15 : new SerializedObserver<T>(t15);
        Scheduler.Worker w15 = this.scheduler.createWorker();
        this.source.subscribe(new DelayObserver<T>(observer, this.delay, this.unit, w15, this.delayError));
    }

    static final class DelayObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Disposable upstream;

        DelayObserver(Observer<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w15, boolean delayError) {
            this.downstream = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w15;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            this.w.schedule(new OnNext(t15), this.delay, this.unit);
        }

        @Override
        public void onError(Throwable t15) {
            this.w.schedule(new OnError(t15), this.delayError ? this.delay : 0L, this.unit);
        }

        @Override
        public void onComplete() {
            this.w.schedule(new OnComplete(), this.delay, this.unit);
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.w.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            @Override
            public void run() {
                try {
                    DelayObserver.this.downstream.onComplete();
                }
                finally {
                    DelayObserver.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable throwable;

            OnError(Throwable throwable) {
                this.throwable = throwable;
            }

            @Override
            public void run() {
                try {
                    DelayObserver.this.downstream.onError(this.throwable);
                }
                finally {
                    DelayObserver.this.w.dispose();
                }
            }
        }

        final class OnNext
        implements Runnable {
            private final T t;

            OnNext(T t15) {
                this.t = t15;
            }

            @Override
            public void run() {
                if (!DelayObserver.this.w.isDisposed()) {
                    DelayObserver.this.downstream.onNext(this.t);
                }
            }
        }
    }
}

