/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;

public final class MaterializeSingleObserver<T>
implements SingleObserver<T>,
MaybeObserver<T>,
CompletableObserver,
Disposable {
    final SingleObserver<? super Notification<T>> downstream;
    Disposable upstream;

    public MaterializeSingleObserver(SingleObserver<? super Notification<T>> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (DisposableHelper.validate(this.upstream, d15)) {
            this.upstream = d15;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onComplete() {
        this.downstream.onSuccess(Notification.createOnComplete());
    }

    @Override
    public void onSuccess(T t15) {
        this.downstream.onSuccess(Notification.createOnNext(t15));
    }

    @Override
    public void onError(Throwable e15) {
        this.downstream.onSuccess(Notification.createOnError(e15));
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }
}

