/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

public final class MaybeFlatMapIterableFlowable<T, R>
extends Flowable<R> {
    final MaybeSource<T> source;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public MaybeFlatMapIterableFlowable(MaybeSource<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        this.source.subscribe(new FlatMapIterableObserver<T, R>(s15, this.mapper));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicIntQueueSubscription<R>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = -8938804753851907758L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final AtomicLong requested;
        Disposable upstream;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean has;
            Iterator<R> iterator2;
            try {
                iterator2 = this.mapper.apply(value).iterator();
                has = iterator2.hasNext();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            if (!has) {
                this.downstream.onComplete();
                return;
            }
            this.it = iterator2;
            this.drain();
        }

        @Override
        public void onError(Throwable e15) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        void fastPath(Subscriber<? super R> a15, Iterator<? extends R> iterator2) {
            boolean b15;
            do {
                R v15;
                if (this.cancelled) {
                    return;
                }
                try {
                    v15 = iterator2.next();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    a15.onError(ex4);
                    return;
                }
                a15.onNext(v15);
                if (this.cancelled) {
                    return;
                }
                try {
                    b15 = iterator2.hasNext();
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    a15.onError(ex5);
                    return;
                }
            } while (b15);
            a15.onComplete();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a15 = this.downstream;
            Iterator<R> iterator2 = this.it;
            if (this.outputFused && iterator2 != null) {
                a15.onNext(null);
                a15.onComplete();
                return;
            }
            int missed = 1;
            while (true) {
                if (iterator2 != null) {
                    long e15;
                    long r15 = this.requested.get();
                    if (r15 == Long.MAX_VALUE) {
                        this.fastPath(a15, iterator2);
                        return;
                    }
                    for (e15 = 0L; e15 != r15; ++e15) {
                        R v15;
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            v15 = Objects.requireNonNull(iterator2.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            a15.onError(ex4);
                            return;
                        }
                        a15.onNext(v15);
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            boolean b15 = iterator2.hasNext();
                            continue;
                        }
                        catch (Throwable ex5) {
                            Exceptions.throwIfFatal(ex5);
                            a15.onError(ex5);
                            return;
                        }
                    }
                    if (e15 != 0L) {
                        BackpressureHelper.produced(this.requested, e15);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (iterator2 != null) continue;
                iterator2 = this.it;
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        @Nullable
        public R poll() {
            Iterator<R> iterator2 = this.it;
            if (iterator2 != null) {
                R v15 = Objects.requireNonNull(iterator2.next(), "The iterator returned a null value");
                if (!iterator2.hasNext()) {
                    this.it = null;
                }
                return v15;
            }
            return null;
        }
    }
}

