/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeEqualSingle<T>
extends Single<Boolean> {
    final MaybeSource<? extends T> source1;
    final MaybeSource<? extends T> source2;
    final BiPredicate<? super T, ? super T> isEqual;

    public MaybeEqualSingle(MaybeSource<? extends T> source1, MaybeSource<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        this.source1 = source1;
        this.source2 = source2;
        this.isEqual = isEqual;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(observer, this.isEqual);
        observer.onSubscribe(parent);
        parent.subscribe(this.source1, this.source2);
    }

    static final class EqualObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = -3031974433025990931L;
        final EqualCoordinator<T> parent;
        Object value;

        EqualObserver(EqualCoordinator<T> parent) {
            this.parent = parent;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.parent.done();
        }

        @Override
        public void onError(Throwable e15) {
            this.parent.error(this, e15);
        }

        @Override
        public void onComplete() {
            this.parent.done();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable {
        final SingleObserver<? super Boolean> downstream;
        final EqualObserver<T> observer1;
        final EqualObserver<T> observer2;
        final BiPredicate<? super T, ? super T> isEqual;

        EqualCoordinator(SingleObserver<? super Boolean> actual, BiPredicate<? super T, ? super T> isEqual) {
            super(2);
            this.downstream = actual;
            this.isEqual = isEqual;
            this.observer1 = new EqualObserver(this);
            this.observer2 = new EqualObserver(this);
        }

        void subscribe(MaybeSource<? extends T> source1, MaybeSource<? extends T> source2) {
            source1.subscribe(this.observer1);
            source2.subscribe(this.observer2);
        }

        @Override
        public void dispose() {
            this.observer1.dispose();
            this.observer2.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.observer1.get());
        }

        void done() {
            if (this.decrementAndGet() == 0) {
                Object o15 = this.observer1.value;
                Object o25 = this.observer2.value;
                if (o15 != null && o25 != null) {
                    boolean b15;
                    try {
                        b15 = this.isEqual.test(o15, o25);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.downstream.onError(ex4);
                        return;
                    }
                    this.downstream.onSuccess((Boolean)b15);
                } else {
                    this.downstream.onSuccess((Boolean)(o15 == null && o25 == null ? 1 : 0));
                }
            }
        }

        void error(EqualObserver<T> sender, Throwable ex4) {
            if (this.getAndSet(0) > 0) {
                if (sender == this.observer1) {
                    this.observer2.dispose();
                } else {
                    this.observer1.dispose();
                }
                this.downstream.onError(ex4);
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

