/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTakeLastTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public FlowableTakeLastTimed(Flowable<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new TakeLastTimedSubscriber<T>(s15, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5677354903406201275L;
        final Subscriber<? super T> downstream;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Subscription upstream;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        TakeLastTimedSubscriber(Subscriber<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            long now = this.scheduler.now(this.unit);
            q15.offer(now, t15);
            this.trim(now, q15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.delayError) {
                this.trim(this.scheduler.now(this.unit), this.queue);
            }
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.trim(this.scheduler.now(this.unit), this.queue);
            this.done = true;
            this.drain();
        }

        void trim(long now, SpscLinkedArrayQueue<Object> q15) {
            long ts4;
            boolean unbounded;
            long time = this.time;
            long c15 = this.count;
            boolean bl4 = unbounded = c15 == Long.MAX_VALUE;
            while (!q15.isEmpty() && ((ts4 = ((Long)q15.peek()).longValue()) < now - time || !unbounded && (long)(q15.size() >> 1) > c15)) {
                q15.poll();
                q15.poll();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Object> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            boolean delayError = this.delayError;
            do {
                if (!this.done) continue;
                boolean empty = q15.isEmpty();
                if (this.checkTerminated(empty, a15, delayError)) {
                    return;
                }
                long r15 = this.requested.get();
                long e15 = 0L;
                while (true) {
                    Object ts4;
                    boolean bl4 = empty = (ts4 = q15.peek()) == null;
                    if (this.checkTerminated(empty, a15, delayError)) {
                        return;
                    }
                    if (r15 == e15) break;
                    q15.poll();
                    Object o15 = q15.poll();
                    a15.onNext(o15);
                    ++e15;
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean empty, Subscriber<? super T> a15, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (delayError) {
                if (empty) {
                    Throwable e15 = this.error;
                    if (e15 != null) {
                        a15.onError(e15);
                    } else {
                        a15.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e16 = this.error;
                if (e16 != null) {
                    this.queue.clear();
                    a15.onError(e16);
                    return true;
                }
                if (empty) {
                    a15.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

