/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTakeLast<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int count;

    public FlowableTakeLast(Flowable<T> source, int count) {
        super(source);
        this.count = count;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new TakeLastSubscriber<T>(s15, this.count));
    }

    static final class TakeLastSubscriber<T>
    extends ArrayDeque<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 7240042530241604978L;
        final Subscriber<? super T> downstream;
        final int count;
        Subscription upstream;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicLong requested = new AtomicLong();
        final AtomicInteger wip = new AtomicInteger();

        TakeLastSubscriber(Subscriber<? super T> actual, int count) {
            this.downstream = actual;
            this.count = count;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.count == this.size()) {
                this.poll();
            }
            this.offer(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
        }

        void drain() {
            if (this.wip.getAndIncrement() == 0) {
                Subscriber a15 = this.downstream;
                long r15 = this.requested.get();
                do {
                    long e15;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.done) continue;
                    for (e15 = 0L; e15 != r15; ++e15) {
                        if (this.cancelled) {
                            return;
                        }
                        Object v15 = this.poll();
                        if (v15 == null) {
                            a15.onComplete();
                            return;
                        }
                        a15.onNext(v15);
                    }
                    if (this.isEmpty()) {
                        a15.onComplete();
                        return;
                    }
                    if (e15 == 0L) continue;
                    r15 = BackpressureHelper.produced(this.requested, e15);
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

