/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTake<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long n;

    public FlowableTake(Flowable<T> source, long n15) {
        super(source);
        this.n = n15;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new TakeSubscriber<T>(s15, this.n));
    }

    static final class TakeSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2288246011222124525L;
        final Subscriber<? super T> downstream;
        long remaining;
        Subscription upstream;

        TakeSubscriber(Subscriber<? super T> actual, long remaining) {
            this.downstream = actual;
            this.remaining = remaining;
            this.lazySet(remaining);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                if (this.remaining == 0L) {
                    s15.cancel();
                    EmptySubscription.complete(this.downstream);
                } else {
                    this.upstream = s15;
                    this.downstream.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t15) {
            long r15 = this.remaining;
            if (r15 > 0L) {
                this.remaining = --r15;
                this.downstream.onNext(t15);
                if (r15 == 0L) {
                    this.upstream.cancel();
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onError(t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                long r15;
                while ((r15 = this.get()) != 0L) {
                    long toRequest = Math.min(r15, n15);
                    long u15 = r15 - toRequest;
                    if (!this.compareAndSet(r15, u15)) continue;
                    this.upstream.request(toRequest);
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

