/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractFlowableWithUpstream<T, U> {
    final Supplier<U> bufferSupplier;
    final Publisher<? extends Open> bufferOpen;
    final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;

    public FlowableBufferBoundary(Flowable<T> source, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Supplier<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s15) {
        BufferBoundarySubscriber parent = new BufferBoundarySubscriber(s15, this.bufferOpen, this.bufferClose, this.bufferSupplier);
        s15.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class BufferCloseSubscriber<T, C extends Collection<? super T>>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<Object>,
    Disposable {
        private static final long serialVersionUID = -8498650778633225126L;
        final BufferBoundarySubscriber<T, C, ?, ?> parent;
        final long index;

        BufferCloseSubscriber(BufferBoundarySubscriber<T, C, ?, ?> parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t15) {
            Subscription s15 = (Subscription)this.get();
            if (s15 != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                s15.cancel();
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.boundaryError(this, t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class BufferBoundarySubscriber<T, C extends Collection<? super T>, Open, Close>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -8466418554264089604L;
        final Subscriber<? super C> downstream;
        final Supplier<C> bufferSupplier;
        final Publisher<? extends Open> bufferOpen;
        final Function<? super Open, ? extends Publisher<? extends Close>> bufferClose;
        final CompositeDisposable subscribers;
        final AtomicLong requested;
        final AtomicReference<Subscription> upstream;
        final AtomicThrowable errors;
        volatile boolean done;
        final SpscLinkedArrayQueue<C> queue;
        volatile boolean cancelled;
        long index;
        Map<Long, C> buffers;
        long emitted;

        BufferBoundarySubscriber(Subscriber<? super C> actual, Publisher<? extends Open> bufferOpen, Function<? super Open, ? extends Publisher<? extends Close>> bufferClose, Supplier<C> bufferSupplier) {
            this.downstream = actual;
            this.bufferSupplier = bufferSupplier;
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.queue = new SpscLinkedArrayQueue(Flowable.bufferSize());
            this.subscribers = new CompositeDisposable();
            this.requested = new AtomicLong();
            this.upstream = new AtomicReference();
            this.buffers = new LinkedHashMap<Long, C>();
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this.upstream, s15)) {
                BufferOpenSubscriber open = new BufferOpenSubscriber(this);
                this.subscribers.add(open);
                this.bufferOpen.subscribe(open);
                s15.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b15 : bufs.values()) {
                    b15.add(t15);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.subscribers.dispose();
                BufferBoundarySubscriber bufferBoundarySubscriber = this;
                synchronized (bufferBoundarySubscriber) {
                    this.buffers = null;
                }
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            this.subscribers.dispose();
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b15 : bufs.values()) {
                    this.queue.offer(b15);
                }
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            BackpressureHelper.add(this.requested, n15);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (SubscriptionHelper.cancel(this.upstream)) {
                this.cancelled = true;
                this.subscribers.dispose();
                BufferBoundarySubscriber bufferBoundarySubscriber = this;
                synchronized (bufferBoundarySubscriber) {
                    this.buffers = null;
                }
                if (this.getAndIncrement() != 0) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open token) {
            Publisher<Close> p15;
            Collection buf;
            try {
                buf = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection");
                p15 = Objects.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null Publisher");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                SubscriptionHelper.cancel(this.upstream);
                this.onError(ex4);
                return;
            }
            long idx = this.index;
            this.index = idx + 1L;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                bufs.put(idx, buf);
            }
            BufferCloseSubscriber bc5 = new BufferCloseSubscriber(this, idx);
            this.subscribers.add(bc5);
            p15.subscribe(bc5);
        }

        void openComplete(BufferOpenSubscriber<Open> os4) {
            this.subscribers.delete(os4);
            if (this.subscribers.size() == 0) {
                SubscriptionHelper.cancel(this.upstream);
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BufferCloseSubscriber<T, C> closer, long idx) {
            this.subscribers.delete(closer);
            boolean makeDone = false;
            if (this.subscribers.size() == 0) {
                makeDone = true;
                SubscriptionHelper.cancel(this.upstream);
            }
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                this.queue.offer(this.buffers.remove(idx));
            }
            if (makeDone) {
                this.done = true;
            }
            this.drain();
        }

        void boundaryError(Disposable subscriber, Throwable ex4) {
            SubscriptionHelper.cancel(this.upstream);
            this.subscribers.delete(subscriber);
            this.onError(ex4);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            long e15 = this.emitted;
            Subscriber<C> a15 = this.downstream;
            SpscLinkedArrayQueue<C> q15 = this.queue;
            do {
                long r15 = this.requested.get();
                while (e15 != r15) {
                    boolean empty;
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && this.errors.get() != null) {
                        q15.clear();
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    Collection v15 = (Collection)q15.poll();
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        a15.onComplete();
                        return;
                    }
                    if (empty) break;
                    a15.onNext(v15);
                    ++e15;
                }
                if (e15 == r15) {
                    if (this.cancelled) {
                        q15.clear();
                        return;
                    }
                    if (this.done) {
                        if (this.errors.get() != null) {
                            q15.clear();
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        if (q15.isEmpty()) {
                            a15.onComplete();
                            return;
                        }
                    }
                }
                this.emitted = e15;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        static final class BufferOpenSubscriber<Open>
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Open>,
        Disposable {
            private static final long serialVersionUID = -8498650778633225126L;
            final BufferBoundarySubscriber<?, ?, Open, ?> parent;

            BufferOpenSubscriber(BufferBoundarySubscriber<?, ?, Open, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Subscription s15) {
                SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
            }

            @Override
            public void onNext(Open t15) {
                this.parent.open(t15);
            }

            @Override
            public void onError(Throwable t15) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.boundaryError(this, t15);
            }

            @Override
            public void onComplete() {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.openComplete(this);
            }

            @Override
            public void dispose() {
                SubscriptionHelper.cancel(this);
            }

            @Override
            public boolean isDisposed() {
                return this.get() == SubscriptionHelper.CANCELLED;
            }
        }
    }
}

