/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        Iterator<? extends CompletableSource> iterator2;
        CompositeDisposable set = new CompositeDisposable();
        AtomicInteger wip = new AtomicInteger(1);
        MergeCompletableObserver shared = new MergeCompletableObserver(observer, set, wip);
        observer.onSubscribe(shared);
        try {
            iterator2 = Objects.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            observer.onError(e15);
            return;
        }
        while (true) {
            CompletableSource c15;
            boolean b15;
            if (set.isDisposed()) {
                return;
            }
            try {
                b15 = iterator2.hasNext();
            }
            catch (Throwable e16) {
                Exceptions.throwIfFatal(e16);
                set.dispose();
                shared.onError(e16);
                return;
            }
            if (!b15) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c15 = Objects.requireNonNull(iterator2.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e17) {
                Exceptions.throwIfFatal(e17);
                set.dispose();
                shared.onError(e17);
                return;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c15.subscribe(shared);
        }
        shared.onComplete();
    }

    static final class MergeCompletableObserver
    extends AtomicBoolean
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = -7730517613164279224L;
        final CompositeDisposable set;
        final CompletableObserver downstream;
        final AtomicInteger wip;

        MergeCompletableObserver(CompletableObserver actual, CompositeDisposable set, AtomicInteger wip) {
            this.downstream = actual;
            this.set = set;
            this.wip = wip;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.set.add(d15);
        }

        @Override
        public void onError(Throwable e15) {
            this.set.dispose();
            if (this.compareAndSet(false, true)) {
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            if (this.wip.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.set.dispose();
            this.set(true);
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }
    }
}

