/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SafeMaybeObserver<T>
implements MaybeObserver<T> {
    final MaybeObserver<? super T> downstream;
    boolean onSubscribeFailed;

    public SafeMaybeObserver(MaybeObserver<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        try {
            this.downstream.onSubscribe(d15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            this.onSubscribeFailed = true;
            d15.dispose();
            RxJavaPlugins.onError(ex4);
        }
    }

    @Override
    public void onSuccess(@NonNull T t15) {
        if (!this.onSubscribeFailed) {
            try {
                this.downstream.onSuccess(t15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }
    }

    @Override
    public void onError(@NonNull Throwable e15) {
        if (this.onSubscribeFailed) {
            RxJavaPlugins.onError(e15);
        } else {
            try {
                this.downstream.onError(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(new CompositeException(e15, ex4));
            }
        }
    }

    @Override
    public void onComplete() {
        if (!this.onSubscribeFailed) {
            try {
                this.downstream.onComplete();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

