/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.Optional;

public final class MaybeMapOptional<T, R>
extends Maybe<R> {
    final Maybe<T> source;
    final Function<? super T, Optional<? extends R>> mapper;

    public MaybeMapOptional(Maybe<T> source, Function<? super T, Optional<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new MapOptionalMaybeObserver<T, R>(observer, this.mapper));
    }

    static final class MapOptionalMaybeObserver<T, R>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        Disposable upstream;

        MapOptionalMaybeObserver(MaybeObserver<? super R> downstream, Function<? super T, Optional<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            Disposable d15 = this.upstream;
            this.upstream = DisposableHelper.DISPOSED;
            d15.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            Optional<R> v15;
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null item");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            if (v15.isPresent()) {
                this.downstream.onSuccess(v15.get());
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

