/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ListCompositeDisposable
implements Disposable,
DisposableContainer {
    List<Disposable> resources;
    volatile boolean disposed;

    public ListCompositeDisposable() {
    }

    public ListCompositeDisposable(Disposable ... resources) {
        Objects.requireNonNull(resources, "resources is null");
        this.resources = new LinkedList<Disposable>();
        for (Disposable d15 : resources) {
            Objects.requireNonNull(d15, "Disposable item is null");
            this.resources.add(d15);
        }
    }

    public ListCompositeDisposable(Iterable<? extends Disposable> resources) {
        Objects.requireNonNull(resources, "resources is null");
        this.resources = new LinkedList<Disposable>();
        for (Disposable disposable : resources) {
            Objects.requireNonNull(disposable, "Disposable item is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Disposable> set;
        if (this.disposed) {
            return;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Disposable d15) {
        Objects.requireNonNull(d15, "d is null");
        if (!this.disposed) {
            ListCompositeDisposable listCompositeDisposable = this;
            synchronized (listCompositeDisposable) {
                if (!this.disposed) {
                    List<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new LinkedList<Disposable>();
                    }
                    set.add(d15);
                    return true;
                }
            }
        }
        d15.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... ds4) {
        Objects.requireNonNull(ds4, "ds is null");
        if (!this.disposed) {
            ListCompositeDisposable object = this;
            synchronized (object) {
                if (!this.disposed) {
                    List<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new LinkedList<Disposable>();
                    }
                    for (Disposable d15 : ds4) {
                        Objects.requireNonNull(d15, "d is null");
                        set.add(d15);
                    }
                    return true;
                }
            }
        }
        for (Disposable d16 : ds4) {
            d16.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(Disposable d15) {
        if (this.delete(d15)) {
            d15.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Disposable d15) {
        Objects.requireNonNull(d15, "Disposable item is null");
        if (this.disposed) {
            return false;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return false;
            }
            List<Disposable> set = this.resources;
            if (set == null || !set.remove(d15)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Disposable> set;
        if (this.disposed) {
            return;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    void dispose(List<Disposable> set) {
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Disposable o15 : set) {
            try {
                o15.dispose();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex4);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw ExceptionHelper.wrapOrThrow((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

