/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors;

import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.JavaOpCodes;
import io.github.skylot.raung.common.RaungAccessFlags;
import io.github.skylot.raung.common.asm.StackType;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import io.github.skylot.raung.disasm.impl.utils.RaungTypes;
import io.github.skylot.raung.disasm.impl.utils.RaungWriter;
import io.github.skylot.raung.disasm.impl.utils.TypeRefUtils;
import io.github.skylot.raung.disasm.impl.visitors.RaungAnnotationVisitor;
import io.github.skylot.raung.disasm.impl.visitors.RaungClassVisitor;
import io.github.skylot.raung.disasm.impl.visitors.data.LabelData;
import io.github.skylot.raung.disasm.impl.visitors.data.LocalVar;
import io.github.skylot.raung.disasm.impl.visitors.data.TryCatchBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class RaungMethodVisitor
extends MethodVisitor {
    private final RaungClassVisitor classVisitor;
    private final RaungWriter writer;
    private final String mthShortId;
    private final RaungWriter tempWriter = new RaungWriter();
    private final List<String> insns = new ArrayList<String>();
    private final Map<Label, LabelData> labels = new IdentityHashMap<Label, LabelData>();
    private final Map<Integer, RaungWriter> insnAttachments = new HashMap<Integer, RaungWriter>();
    private int catchCount;

    public RaungMethodVisitor(RaungClassVisitor classVisitor, String mthShortId) {
        super(classVisitor.getApi());
        this.classVisitor = classVisitor;
        this.writer = classVisitor.getWriter();
        this.mthShortId = mthShortId;
    }

    @Override
    public void visitParameter(String name, int access) {
        this.writer.startLine(".param").space().add(RaungAccessFlags.format(access, RaungAccessFlags.Scope.PARAM)).add(name);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return RaungAnnotationVisitor.buildDefaultValueVisitor(this.classVisitor);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        return RaungAnnotationVisitor.buildAnnotation(this.classVisitor, descriptor2, visible);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        return RaungAnnotationVisitor.buildTypeAnnotation(this.classVisitor, typeRef, typePath, descriptor2, visible);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        int insn = this.insns.size() - 1;
        if (insn < 0) {
            throw new RaungDisasmException("No instructions to attach annotation");
        }
        RaungWriter rw4 = this.insnAttachments.computeIfAbsent(insn, i15 -> new RaungWriter().setIndent(this.writer.getIndent()));
        return RaungAnnotationVisitor.buildInsnAnnotation(this.classVisitor, rw4, typeRef, typePath, descriptor2, visible);
    }

    @Override
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor2, boolean visible) {
        return RaungAnnotationVisitor.buildParamAnnotation(this.classVisitor, parameter, descriptor2, visible);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.writer.startLine("# attribute " + attribute);
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        if (this.classVisitor.getArgs().isAutoFrames()) {
            return;
        }
        RaungWriter rw4 = this.tmpWriter();
        rw4.add(Directive.STACK);
        switch (type) {
            case 3: {
                rw4.add("same");
                break;
            }
            case 4: {
                rw4.add("same1").space().add(this.formatStackType(stack[0]));
                break;
            }
            case 2: {
                rw4.add("chop").space().add(numLocal);
                break;
            }
            case 1: {
                rw4.add("append");
                rw4.setIndent(this.writer.getIndent() + 2);
                for (int i15 = 0; i15 < numLocal; ++i15) {
                    rw4.startLine(this.formatStackType(local[i15]));
                }
                rw4.setIndent(this.writer.getIndent());
                rw4.startLine(".end stack");
                break;
            }
            case 0: {
                rw4.add("full");
                this.writeCompleteFrame(rw4, numLocal, local, numStack, stack);
                break;
            }
            case -1: {
                rw4.add("new");
                this.writeCompleteFrame(rw4, numLocal, local, numStack, stack);
                break;
            }
            default: {
                throw new RaungDisasmException("Unexpected frame type: " + type);
            }
        }
        this.insns.add(rw4.getCode());
    }

    private void writeCompleteFrame(RaungWriter rw4, int numLocal, Object[] local, int numStack, Object[] stack) {
        int i15;
        rw4.setIndent(this.writer.getIndent() + 2);
        for (i15 = 0; i15 < numStack; ++i15) {
            rw4.startLine("stack ").add(i15).space().add(this.formatStackType(stack[i15]));
        }
        for (i15 = 0; i15 < numLocal; ++i15) {
            rw4.startLine("local ").add(i15).space().add(this.formatStackType(local[i15]));
        }
        rw4.setIndent(this.writer.getIndent());
        rw4.startLine(".end stack");
    }

    private String formatStackType(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            StackType type = StackType.getByValue((Integer)value);
            if (type == null) {
                throw new RaungDisasmException("Unknown primitive stack type: " + value);
            }
            return type.getName();
        }
        if (value instanceof Label) {
            Label lbl = (Label)value;
            LabelData labelData = this.getLabelData(lbl);
            labelData.addUse();
            return "Uninitialized " + labelData.getName();
        }
        throw new IllegalArgumentException("Unknown stack type: " + value + ", class: " + value.getClass().getName());
    }

    @Override
    public void visitInsn(int opcode) {
        this.insns.add(JavaOpCodes.getName(opcode));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.insns.add(this.formatInsn(opcode).add(operand).getCode());
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.insns.add(this.formatInsn(opcode).add(var).getCode());
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.insns.add(this.formatInsn(opcode).add(type).getCode());
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor2) {
        this.insns.add(this.formatInsn(opcode).add(owner).space().add(name).space().add(descriptor2).getCode());
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor2, boolean isInterface) {
        RaungWriter rw4 = this.formatInsn(opcode);
        if (isInterface && opcode != 185) {
            rw4.add("interface ");
        }
        rw4.add(owner).space().add(name).space().add(descriptor2);
        this.insns.add(rw4.getCode());
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor2, Handle mthHandle, Object ... args) {
        RaungWriter rw4 = this.tmpWriter().add("invokedynamic").space().add(name).space().add(descriptor2);
        rw4.setIndent(this.writer.getIndent() + 2);
        rw4.startLine(RaungTypes.formatHandle(mthHandle));
        for (int i15 = 0; i15 < args.length; ++i15) {
            rw4.startLine(".arg").space().add(i15).space().add(RaungTypes.format(args[i15]));
        }
        rw4.setIndent(this.writer.getIndent());
        rw4.startLine(".end invokedynamic");
        this.insns.add(rw4.getCode());
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        LabelData ld5 = this.getLabelData(label).addUse();
        this.insns.add(this.formatInsn(opcode).add(ld5.getName()).getCode());
    }

    @Override
    public void visitLdcInsn(Object value) {
        boolean wide = value instanceof Long || value instanceof Double;
        String insn = wide ? "ldc2_w" : "ldc";
        this.insns.add(this.tmpWriter().add(insn).space().add(RaungTypes.format(value)).getCode());
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.insns.add(this.tmpWriter().add("iinc").space().add(var).space().add(increment).getCode());
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        String switchType = this.classVisitor.getArgs().isAutoSwitch() ? "switch" : "tableswitch";
        RaungWriter rw4 = this.tmpWriter().add(switchType);
        rw4.setIndent(this.writer.getIndent() + 1);
        int l15 = 0;
        for (int i15 = min; i15 <= max; ++i15) {
            LabelData label = this.getLabelData(labels[l15++]).addUse();
            rw4.startLine().add(i15).space().add(label.getName());
        }
        rw4.startLine("default ").add(this.getLabelData(dflt).addUse().getName());
        rw4.setIndent(this.writer.getIndent());
        rw4.startLine(".end ").add(switchType);
        this.insns.add(rw4.getCode());
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        String switchType = this.classVisitor.getArgs().isAutoSwitch() ? "switch" : "lookupswitch";
        RaungWriter rw4 = this.tmpWriter().add(switchType);
        rw4.setIndent(this.writer.getIndent() + 1);
        int len = keys2.length;
        for (int i15 = 0; i15 < len; ++i15) {
            LabelData label = this.getLabelData(labels[i15]).addUse();
            rw4.startLine().add(keys2[i15]).space().add(label.getName());
        }
        rw4.startLine("default ").add(this.getLabelData(dflt).addUse().getName());
        rw4.setIndent(this.writer.getIndent());
        rw4.startLine(".end ").add(switchType);
        this.insns.add(rw4.getCode());
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor2, int numDimensions) {
        this.insns.add(this.tmpWriter().add("multianewarray").space().add(descriptor2).space().add(numDimensions).getCode());
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        LabelData startLabel = this.getLabelData(start).addUse();
        LabelData endLabel = this.getLabelData(end).addUse();
        LabelData handlerLabel = this.getLabelData(handler).addUse();
        TryCatchBlock tryCatchBlock = new TryCatchBlock(this.catchCount++, startLabel, endLabel, handlerLabel, type);
        endLabel.addCatch(tryCatchBlock);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        this.writer.startLine("# try-catch annotation " + TypeRefUtils.formatPath(typeRef, typePath) + " " + descriptor2 + " " + visible);
        return null;
    }

    @Override
    public void visitLocalVariable(String name, String descriptor2, String signature, Label start, Label end, int index) {
        if (this.addDebugInfo()) {
            LocalVar var = new LocalVar(index, name, descriptor2, signature);
            this.getLabelData(start).addStartVars(var);
            this.getLabelData(end).addEndVar(var);
        }
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor2, boolean visible) {
        return null;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        if (this.addDebugInfo()) {
            LabelData ld5 = this.getLabelData(start);
            ld5.setLine(line);
        }
    }

    @Override
    public void visitLabel(Label label) {
        LabelData ld5 = this.getLabelData(label);
        ld5.setInsnRef(this.insns.size());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.classVisitor.getArgs().isAutoMax()) {
            return;
        }
        this.writer.startLine(".max stack").space().add(maxStack);
        this.writer.startLine(".max locals").space().add(maxLocals);
        this.writer.newLine();
    }

    @Override
    public void visitEnd() {
        try {
            HashMap<Integer, LabelData> labelsMap = new HashMap<Integer, LabelData>();
            for (LabelData ld5 : this.labels.values()) {
                LabelData prevLabel = labelsMap.put(ld5.getInsnRef(), ld5);
                if (prevLabel == null) continue;
                throw new RaungDisasmException("Duplicate label, " + ld5 + ", prev: " + prevLabel);
            }
            int insnsCount = this.insns.size();
            for (int i15 = 0; i15 < insnsCount; ++i15) {
                LabelData labelData = (LabelData)labelsMap.get(i15);
                if (labelData != null) {
                    this.handleLabelDataBeforeInsn(labelData);
                }
                this.addInsnAttachments(i15);
                this.writer.startLine(this.insns.get(i15));
                if (labelData == null) continue;
                this.handleLabelDataAfterInsn(labelData, i15 == insnsCount - 1);
            }
            this.writer.setIndent(0);
            this.writer.startLine(".end method");
        }
        catch (Exception e15) {
            throw new RaungDisasmException("Failed to process method: " + this, e15);
        }
    }

    private void addInsnAttachments(int insnOffset) {
        RaungWriter rw4 = this.insnAttachments.get(insnOffset);
        if (rw4 != null) {
            this.writer.add(rw4);
        }
    }

    private void handleLabelDataBeforeInsn(LabelData labelData) {
        if (labelData.getUseCount() != 0) {
            this.writer.decreaseIndent();
            this.writer.startLine().add(labelData.getName());
            this.writer.increaseIndent();
        }
        for (LocalVar startVar : labelData.getStartVars()) {
            this.writer.startLine(".local").space().add(startVar.getIndex()).space().addString(startVar.getName()).space().add(startVar.getType());
            if (startVar.getSignature() == null) continue;
            this.writer.space().add(startVar.getSignature());
        }
        for (TryCatchBlock catchBlock : labelData.getCatches()) {
            String type = catchBlock.getType();
            this.writer.startLine(Directive.CATCH);
            if (this.classVisitor.getArgs().isSaveCatchNumber()) {
                this.writer.add('@').add(catchBlock.getId()).space();
            }
            this.writer.add(type == null ? "all" : type).space().add(catchBlock.getStart().getName()).space().add("..").space().add(catchBlock.getEnd().getName()).space().add("goto").space().add(catchBlock.getHandler().getName());
        }
        for (Integer line : labelData.getLines()) {
            this.writer.startLine(".line ").add(line);
        }
    }

    private void handleLabelDataAfterInsn(LabelData labelData, boolean lastInsn) {
        if (!lastInsn && !labelData.getEndVars().isEmpty()) {
            for (LocalVar endVar : labelData.getEndVars()) {
                this.writer.startLine(".end local ").add(endVar.getIndex()).add(" # ").addString(endVar.getName());
            }
        }
    }

    private LabelData getLabelData(Label label) {
        return this.labels.computeIfAbsent(label, l15 -> new LabelData(label, String.format(":L%d", this.labels.size())));
    }

    private RaungWriter tmpWriter() {
        return this.tempWriter.clear();
    }

    private RaungWriter formatInsn(int opcode) {
        return this.tmpWriter().add(JavaOpCodes.getName(opcode)).space();
    }

    private boolean addDebugInfo() {
        return !this.classVisitor.getArgs().isIgnoreDebugInfo();
    }

    public String toString() {
        return this.classVisitor + "->" + this.mthShortId;
    }
}

