/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.PixelInfoStatusBar;
import hu.kazocsaba.imageviewer.PixelModel;
import hu.kazocsaba.imageviewer.StatusBar;
import hu.kazocsaba.imageviewer.Synchronizer;
import java.util.Collection;
import java.util.Iterator;

public final class ImageViewerUtil {
    private ImageViewerUtil() {
    }

    public static void synchronizeViewers(ImageViewer first, ImageViewer ... others) {
        Synchronizer mainSynchronizer = first.getSynchronizer();
        for (ImageViewer other : others) {
            mainSynchronizer.add(other);
        }
    }

    public static void synchronizeViewers(Collection<ImageViewer> viewers) {
        Iterator<ImageViewer> iterator2 = viewers.iterator();
        if (!iterator2.hasNext()) {
            return;
        }
        Synchronizer mainSynchronizer = iterator2.next().getSynchronizer();
        while (iterator2.hasNext()) {
            mainSynchronizer.add(iterator2.next());
        }
    }

    public static void synchronizePixelInfoStatusBars(ImageViewer ... viewers) {
        PixelModel model = null;
        for (ImageViewer viewer : viewers) {
            StatusBar bar = viewer.getStatusBar();
            if (!(bar instanceof PixelInfoStatusBar)) continue;
            if (model == null) {
                model = ((PixelInfoStatusBar)bar).getModel();
                continue;
            }
            ((PixelInfoStatusBar)bar).setModel(model);
        }
    }
}

