/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.swing;

import hu.akarnokd.rxjava3.swing.AbstractEventConsumer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

final class MouseEventObservable
extends Observable<MouseEvent> {
    final Component widget;
    final int flags;

    MouseEventObservable(Component widget, int flags) {
        this.widget = widget;
        this.flags = flags;
    }

    @Override
    protected void subscribeActual(Observer<? super MouseEvent> observer) {
        Component w15 = this.widget;
        int f15 = this.flags;
        MouseEventConsumer aec = new MouseEventConsumer(observer, w15, f15);
        observer.onSubscribe(aec);
        if ((f15 & 1) != 0) {
            w15.addMouseListener(aec);
        }
        if ((f15 & 2) != 0) {
            w15.addMouseMotionListener(aec);
        }
        if ((f15 & 4) != 0) {
            w15.addMouseWheelListener(aec);
        }
        if (aec.get() == null) {
            aec.onDispose(w15);
        }
    }

    static final class MouseEventConsumer
    extends AbstractEventConsumer<MouseEvent, Component>
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = -3605206827474016488L;
        final int flags;

        MouseEventConsumer(Observer<? super MouseEvent> actual, Component widget, int flags) {
            super(actual, widget);
            this.flags = flags;
        }

        @Override
        protected void onDispose(Component w15) {
            int f15 = this.flags;
            if ((f15 & 1) != 0) {
                w15.removeMouseListener(this);
            }
            if ((f15 & 2) != 0) {
                w15.removeMouseMotionListener(this);
            }
            if ((f15 & 4) != 0) {
                w15.removeMouseWheelListener(this);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseDragged(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseClicked(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mousePressed(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseReleased(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseEntered(MouseEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void mouseExited(MouseEvent e15) {
            this.actual.onNext(e15);
        }
    }
}

