/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class PackBitsEncoder
implements Encoder {
    private final byte[] buffer = new byte[128];

    @Override
    public void encode(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        this.encode(outputStream, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.remaining());
    }

    private void encode(OutputStream outputStream, byte[] byArray, int n15, int n16) throws IOException {
        int n17 = n15;
        int n18 = n15 + n16 - 1;
        int n19 = n18 - 1;
        while (n17 <= n18) {
            int n25;
            byte by = byArray[n17];
            for (n25 = 1; n25 < 127 && n17 < n18 && byArray[n17] == byArray[n17 + 1]; ++n17, ++n25) {
            }
            if (n25 > 1) {
                ++n17;
                outputStream.write(-(n25 - 1));
                outputStream.write(by);
            }
            n25 = 0;
            while (n25 < 128 && (n17 < n18 && byArray[n17] != byArray[n17 + 1] || n17 < n19 && byArray[n17] != byArray[n17 + 2])) {
                this.buffer[n25++] = byArray[n17++];
            }
            if (n17 == n18 && n25 > 0 && n25 < 128) {
                this.buffer[n25++] = byArray[n17++];
            }
            if (n25 > 0) {
                outputStream.write(n25 - 1);
                outputStream.write(this.buffer, 0, n25);
            }
            if (n17 != n18 || n25 > 0 && n25 < 128) continue;
            outputStream.write(0);
            outputStream.write(byArray[n17++]);
        }
    }
}

