/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileSystem;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.util.StringTokenIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

final class UnixFileSystem
extends FileSystem {
    UnixFileSystem() {
    }

    @Override
    long getFreeSpace(File file2) {
        try {
            return this.getNumber(file2, 3);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    long getTotalSpace(File file2) {
        try {
            return this.getNumber(file2, 5);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNumber(File file2, int n15) throws IOException {
        BufferedReader bufferedReader = UnixFileSystem.exec(new String[]{"df", "-k", file2.getAbsolutePath()});
        String string = null;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string2;
            }
        }
        finally {
            FileUtil.close(bufferedReader);
        }
        if (string != null) {
            String string3 = null;
            StringTokenIterator stringTokenIterator = new StringTokenIterator(string, " ", -1);
            for (int i15 = 0; i15 < n15 && stringTokenIterator.hasNext(); ++i15) {
                string3 = stringTokenIterator.nextToken();
            }
            if (string3 != null) {
                try {
                    return Long.parseLong(string3) * 1024L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    @Override
    String getName() {
        return "Unix";
    }
}

