/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.AffineTransformOp;
import com.twelvemonkeys.image.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class ResampleOp
implements BufferedImageOp {
    public static final int FILTER_UNDEFINED = 0;
    public static final int FILTER_POINT = 1;
    public static final int FILTER_BOX = 2;
    public static final int FILTER_TRIANGLE = 3;
    public static final int FILTER_HERMITE = 4;
    public static final int FILTER_HANNING = 5;
    public static final int FILTER_HAMMING = 6;
    public static final int FILTER_BLACKMAN = 7;
    public static final int FILTER_GAUSSIAN = 8;
    public static final int FILTER_QUADRATIC = 9;
    public static final int FILTER_CUBIC = 10;
    public static final int FILTER_CATROM = 11;
    public static final int FILTER_MITCHELL = 12;
    public static final int FILTER_LANCZOS = 13;
    public static final int FILTER_BLACKMAN_BESSEL = 14;
    public static final int FILTER_BLACKMAN_SINC = 15;
    public static final RenderingHints.Key KEY_RESAMPLE_INTERPOLATION = new Key("ResampleInterpolation");
    public static final Object VALUE_INTERPOLATION_POINT = new Value(KEY_RESAMPLE_INTERPOLATION, "Point", 1);
    public static final Object VALUE_INTERPOLATION_BOX = new Value(KEY_RESAMPLE_INTERPOLATION, "Box", 2);
    public static final Object VALUE_INTERPOLATION_TRIANGLE = new Value(KEY_RESAMPLE_INTERPOLATION, "Triangle", 3);
    public static final Object VALUE_INTERPOLATION_HERMITE = new Value(KEY_RESAMPLE_INTERPOLATION, "Hermite", 4);
    public static final Object VALUE_INTERPOLATION_HANNING = new Value(KEY_RESAMPLE_INTERPOLATION, "Hanning", 5);
    public static final Object VALUE_INTERPOLATION_HAMMING = new Value(KEY_RESAMPLE_INTERPOLATION, "Hamming", 6);
    public static final Object VALUE_INTERPOLATION_BLACKMAN = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman", 7);
    public static final Object VALUE_INTERPOLATION_GAUSSIAN = new Value(KEY_RESAMPLE_INTERPOLATION, "Gaussian", 8);
    public static final Object VALUE_INTERPOLATION_QUADRATIC = new Value(KEY_RESAMPLE_INTERPOLATION, "Quadratic", 9);
    public static final Object VALUE_INTERPOLATION_CUBIC = new Value(KEY_RESAMPLE_INTERPOLATION, "Cubic", 10);
    public static final Object VALUE_INTERPOLATION_CATROM = new Value(KEY_RESAMPLE_INTERPOLATION, "Catrom", 11);
    public static final Object VALUE_INTERPOLATION_MITCHELL = new Value(KEY_RESAMPLE_INTERPOLATION, "Mitchell", 12);
    public static final Object VALUE_INTERPOLATION_LANCZOS = new Value(KEY_RESAMPLE_INTERPOLATION, "Lanczos", 13);
    public static final Object VALUE_INTERPOLATION_BLACKMAN_BESSEL = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman-Bessel", 14);
    public static final Object VALUE_INTERPOLATION_BLACKMAN_SINC = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman-Sinc", 15);
    private final int width;
    private final int height;
    private final int filterType;
    private static final double B = 0.3333333333333333;
    private static final double C = 0.3333333333333333;
    private static final double P0 = 0.8888888888888888;
    private static final double P2 = -2.0;
    private static final double P3 = 1.1666666666666667;
    private static final double Q0 = 1.7777777777777777;
    private static final double Q1 = -3.3333333333333335;
    private static final double Q2 = 2.0;
    private static final double Q3 = -0.3888888888888889;

    public ResampleOp(int n15, int n16) {
        this(n15, n16, 0);
    }

    public ResampleOp(int n15, int n16, RenderingHints renderingHints) {
        this(n15, n16, ResampleOp.getFilterType(renderingHints));
    }

    public ResampleOp(int n15, int n16, int n17) {
        if (n15 <= 0 || n16 <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        this.width = n15;
        this.height = n16;
        this.filterType = ResampleOp.validateFilterType(n17);
    }

    private static int validateFilterType(int n15) {
        switch (n15) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return n15;
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + n15);
    }

    private static int getFilterType(RenderingHints renderingHints) {
        if (renderingHints == null) {
            return 0;
        }
        if (renderingHints.containsKey(KEY_RESAMPLE_INTERPOLATION)) {
            Object object = renderingHints.get(KEY_RESAMPLE_INTERPOLATION);
            if (!KEY_RESAMPLE_INTERPOLATION.isCompatibleValue(object)) {
                throw new IllegalArgumentException(object + " incompatible with key " + KEY_RESAMPLE_INTERPOLATION);
            }
            return object != null ? ((Value)object).getFilterType() : 0;
        }
        if (RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(renderingHints.get(RenderingHints.KEY_INTERPOLATION)) || !renderingHints.containsKey(RenderingHints.KEY_INTERPOLATION) && (RenderingHints.VALUE_RENDER_SPEED.equals(renderingHints.get(RenderingHints.KEY_RENDERING)) || RenderingHints.VALUE_COLOR_RENDER_SPEED.equals(renderingHints.get(RenderingHints.KEY_COLOR_RENDERING)))) {
            return 1;
        }
        if (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(renderingHints.get(RenderingHints.KEY_INTERPOLATION))) {
            return 3;
        }
        if (RenderingHints.VALUE_INTERPOLATION_BICUBIC.equals(renderingHints.get(RenderingHints.KEY_INTERPOLATION))) {
            return 9;
        }
        if (RenderingHints.VALUE_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_RENDERING)) || RenderingHints.VALUE_COLOR_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_COLOR_RENDERING))) {
            return 12;
        }
        return 0;
    }

    @Override
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorModel colorModel;
        if (bufferedImage == null) {
            throw new NullPointerException("Input == null");
        }
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException("Output image cannot be the same as the input image");
        }
        switch (this.filterType) {
            case 1: {
                if (bufferedImage.getType() != 0) {
                    return ResampleOp.fastResample(bufferedImage, bufferedImage2, this.width, this.height, 1);
                }
            }
            case 3: {
                if (bufferedImage.getType() != 0) {
                    return ResampleOp.fastResample(bufferedImage, bufferedImage2, this.width, this.height, 2);
                }
            }
            case 9: {
                if (bufferedImage.getType() == 0) break;
                return ResampleOp.fastResample(bufferedImage, bufferedImage2, this.width, this.height, 3);
            }
        }
        InterpolationFilter interpolationFilter = ResampleOp.createFilter(this.filterType);
        if ((double)Math.min(bufferedImage.getWidth(), bufferedImage.getHeight()) <= interpolationFilter.support() || (double)Math.min(this.width, this.height) <= interpolationFilter.support()) {
            return ResampleOp.fastResample(bufferedImage, bufferedImage2, this.width, this.height, 2);
        }
        BufferedImage bufferedImage3 = this.filterType != 1 && this.filterType != 2 && (colorModel = bufferedImage.getColorModel()) instanceof IndexColorModel ? ImageUtil.toBuffered(bufferedImage, colorModel.hasAlpha() ? 6 : 5) : bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2 != null && bufferedImage3.getType() != 0 ? ImageUtil.toBuffered(bufferedImage2, bufferedImage3.getType()) : this.createCompatibleDestImage(bufferedImage3, null);
        this.resample(bufferedImage3, bufferedImage4, interpolationFilter);
        if (bufferedImage2 != null && bufferedImage2 != bufferedImage4) {
            ImageUtil.drawOnto(bufferedImage2, bufferedImage4);
            bufferedImage4 = bufferedImage2;
        }
        return bufferedImage4;
    }

    private static BufferedImage fastResample(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n15, int n16, int n17) {
        AffineTransformOp affineTransformOp;
        AffineTransform affineTransform;
        double d15;
        double d16;
        BufferedImage bufferedImage3 = bufferedImage;
        if (n17 > 1 && (n15 < bufferedImage.getWidth() || n16 < bufferedImage.getHeight())) {
            int n18;
            int n19 = n16;
            for (n18 = n15; n18 < bufferedImage.getWidth() / 2; n18 *= 2) {
            }
            while (n19 < bufferedImage.getHeight() / 2) {
                n19 *= 2;
            }
            d16 = (double)n18 / (double)bufferedImage.getWidth();
            d15 = (double)n19 / (double)bufferedImage.getHeight();
            affineTransform = AffineTransform.getScaleInstance(d16, d15);
            affineTransformOp = new AffineTransformOp(affineTransform, 2);
            bufferedImage3 = affineTransformOp.filter(bufferedImage3, null);
        }
        affineTransformOp = null;
        d16 = (double)n15 / (double)bufferedImage3.getWidth();
        d15 = (double)n16 / (double)bufferedImage3.getHeight();
        if (n17 > 1) {
            while (d16 < 0.5 || d15 < 0.5) {
                if (d16 >= 0.5) {
                    affineTransform = AffineTransform.getScaleInstance(1.0, 0.5);
                    affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    d15 *= 2.0;
                } else if (d15 >= 0.5) {
                    affineTransform = AffineTransform.getScaleInstance(0.5, 1.0);
                    affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    d16 *= 2.0;
                } else {
                    d16 *= 2.0;
                    d15 *= 2.0;
                }
                if (affineTransformOp == null) {
                    affineTransform = AffineTransform.getScaleInstance(0.5, 0.5);
                    affineTransformOp = new AffineTransformOp(affineTransform, 2);
                }
                bufferedImage3 = affineTransformOp.filter(bufferedImage3, null);
            }
        }
        affineTransform = AffineTransform.getScaleInstance(d16, d15);
        affineTransformOp = new AffineTransformOp(affineTransform, n17);
        return affineTransformOp.filter(bufferedImage3, bufferedImage2);
    }

    public int getFilterType() {
        return this.filterType;
    }

    private static InterpolationFilter createFilter(int n15) {
        if (n15 == 0) {
            n15 = 13;
        }
        switch (n15) {
            case 1: {
                return new PointFilter();
            }
            case 2: {
                return new BoxFilter();
            }
            case 3: {
                return new TriangleFilter();
            }
            case 4: {
                return new HermiteFilter();
            }
            case 5: {
                return new HanningFilter();
            }
            case 6: {
                return new HammingFilter();
            }
            case 7: {
                return new BlacmanFilter();
            }
            case 8: {
                return new GaussianFilter();
            }
            case 9: {
                return new QuadraticFilter();
            }
            case 10: {
                return new CubicFilter();
            }
            case 11: {
                return new CatromFilter();
            }
            case 12: {
                return new MitchellFilter();
            }
            case 13: {
                return new LanczosFilter();
            }
            case 14: {
                return new BlackmanBesselFilter();
            }
            case 15: {
                return new BlackmanSincFilter();
            }
        }
        throw new IllegalStateException("Unknown filter type: " + n15);
    }

    @Override
    public final BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (bufferedImage == null) {
            throw new NullPointerException("pInput == null");
        }
        ColorModel colorModel2 = colorModel != null ? colorModel : bufferedImage.getColorModel();
        return new BufferedImage(colorModel2, ImageUtil.createCompatibleWritableRaster(bufferedImage, colorModel2, this.width, this.height), colorModel2.isAlphaPremultiplied(), null);
    }

    @Override
    public RenderingHints getRenderingHints() {
        Object object;
        switch (this.filterType) {
            case 0: {
                return null;
            }
            case 1: {
                object = VALUE_INTERPOLATION_POINT;
                break;
            }
            case 2: {
                object = VALUE_INTERPOLATION_BOX;
                break;
            }
            case 3: {
                object = VALUE_INTERPOLATION_TRIANGLE;
                break;
            }
            case 4: {
                object = VALUE_INTERPOLATION_HERMITE;
                break;
            }
            case 5: {
                object = VALUE_INTERPOLATION_HANNING;
                break;
            }
            case 6: {
                object = VALUE_INTERPOLATION_HAMMING;
                break;
            }
            case 7: {
                object = VALUE_INTERPOLATION_BLACKMAN;
                break;
            }
            case 8: {
                object = VALUE_INTERPOLATION_GAUSSIAN;
                break;
            }
            case 9: {
                object = VALUE_INTERPOLATION_QUADRATIC;
                break;
            }
            case 10: {
                object = VALUE_INTERPOLATION_CUBIC;
                break;
            }
            case 11: {
                object = VALUE_INTERPOLATION_CATROM;
                break;
            }
            case 12: {
                object = VALUE_INTERPOLATION_MITCHELL;
                break;
            }
            case 13: {
                object = VALUE_INTERPOLATION_LANCZOS;
                break;
            }
            case 14: {
                object = VALUE_INTERPOLATION_BLACKMAN_BESSEL;
                break;
            }
            case 15: {
                object = VALUE_INTERPOLATION_BLACKMAN_SINC;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown filter type: " + this.filterType);
            }
        }
        return new RenderingHints(KEY_RESAMPLE_INTERPOLATION, object);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
            point2D2.setLocation(point2D);
        }
        return point2D2;
    }

    private static double sinc(double d15) {
        if ((d15 *= Math.PI) != 0.0) {
            return Math.sin(d15) / d15;
        }
        return 1.0;
    }

    private static double j1(double d15) {
        double[] dArray = new double[]{5.811993540016061E20, -6.672106568924916E19, 2.3164335806340024E18, -3.588817569910106E16, 2.9087952638347756E14, -1.3229834803321265E12, 3.4132341823017006E9, -4695753.530642996, 2701.1227108923235};
        double[] dArray2 = new double[]{1.1623987080032122E21, 1.185770712190321E19, 6.092061398917522E16, 2.0816612213076075E14, 5.2437102621676495E11, 1.013863514358674E9, 1501793.5949985855, 1606.9315734814877, 1.0};
        double d16 = dArray[8];
        double d17 = dArray2[8];
        for (int i15 = 7; i15 >= 0; --i15) {
            d16 = d16 * d15 * d15 + dArray[i15];
            d17 = d17 * d15 * d15 + dArray2[i15];
        }
        return d16 / d17;
    }

    private static double p1(double d15) {
        double[] dArray = new double[]{35224.66491336798, 62758.84524716128, 31353.963110915956, 4985.4832060594335, 211.15291828539623, 1.2571716929145342};
        double[] dArray2 = new double[]{35224.66491336798, 62694.34695935605, 31240.406381904104, 4930.396490181089, 203.07751891347593, 1.0};
        double d16 = dArray[5];
        double d17 = dArray2[5];
        for (int i15 = 4; i15 >= 0; --i15) {
            d16 = d16 * (8.0 / d15) * (8.0 / d15) + dArray[i15];
            d17 = d17 * (8.0 / d15) * (8.0 / d15) + dArray2[i15];
        }
        return d16 / d17;
    }

    private static double q1(double d15) {
        double[] dArray = new double[]{351.17519143035526, 721.0391804904475, 425.98730116544425, 83.18989576738508, 4.568171629551227, 0.03532840052740124};
        double[] dArray2 = new double[]{7491.737417180912, 15414.177339265098, 9152.231701516992, 1811.1867005523513, 103.81875854621337, 1.0};
        double d16 = dArray[5];
        double d17 = dArray2[5];
        for (int i15 = 4; i15 >= 0; --i15) {
            d16 = d16 * (8.0 / d15) * (8.0 / d15) + dArray[i15];
            d17 = d17 * (8.0 / d15) * (8.0 / d15) + dArray2[i15];
        }
        return d16 / d17;
    }

    static double besselOrderOne(double d15) {
        if (d15 == 0.0) {
            return 0.0;
        }
        double d16 = d15;
        if (d15 < 0.0) {
            d15 = -d15;
        }
        if (d15 < 8.0) {
            return d16 * ResampleOp.j1(d15);
        }
        double d17 = Math.sqrt(2.0 / (Math.PI * d15)) * (ResampleOp.p1(d15) * (1.0 / Math.sqrt(2.0) * (Math.sin(d15) - Math.cos(d15))) - 8.0 / d15 * ResampleOp.q1(d15) * (-1.0 / Math.sqrt(2.0) * (Math.sin(d15) + Math.cos(d15))));
        if (d16 < 0.0) {
            d17 = -d17;
        }
        return d17;
    }

    private static double bessel(double d15) {
        if (d15 == 0.0) {
            return 0.7853981633974483;
        }
        return ResampleOp.besselOrderOne(Math.PI * d15) / (2.0 * d15);
    }

    private static double blackman(double d15) {
        return 0.42 + 0.5 * Math.cos(Math.PI * d15) + 0.08 * Math.cos(Math.PI * 2 * d15);
    }

    static int round(double d15) {
        int n15 = (int)d15;
        double d16 = d15 - (double)n15;
        if (d16 < 0.0) {
            d16 = -d16;
        }
        if (d16 >= 0.5) {
            n15 = d15 < 0.0 ? --n15 : ++n15;
        }
        return n15;
    }

    private ContributorList calcXContrib(double d15, double d16, int n15, InterpolationFilter interpolationFilter, int n16) {
        ContributorList contributorList;
        block11: {
            block10: {
                int n17;
                contributorList = new ContributorList();
                if (!(d15 < 1.0)) break block10;
                double d17 = d16 / d15;
                double d18 = 1.0 / d15;
                if (d17 <= 0.5) {
                    d17 = 0.500001;
                    d18 = 1.0;
                }
                contributorList.p = new Contributor[(int)(d17 * 2.0 + 1.0 + 0.5)];
                double d19 = (double)n16 / d15;
                int n18 = (int)Math.ceil(d19 - d17);
                int n19 = (int)Math.floor(d19 + d17);
                double d25 = 0.0;
                for (n17 = n18; n17 <= n19; ++n17) {
                    double d26 = d19 - (double)n17;
                    d26 = interpolationFilter.filter(d26 / d18) / d18;
                    int n25 = n17 < 0 ? -n17 : (n17 >= n15 ? n15 - n17 + n15 - 1 : n17);
                    if (n25 >= n15) {
                        n25 %= n15;
                    } else if (n25 < 0) {
                        n25 = n15 - 1;
                    }
                    ++contributorList.n;
                    contributorList.p[var23_22] = new Contributor();
                    contributorList.p[var23_22].pixel = n25;
                    contributorList.p[var23_22].weight = d26;
                    d25 += d26;
                }
                if (d25 == 0.0 || d25 == 1.0) break block11;
                d25 = 1.0 / d25;
                for (n17 = 0; n17 < contributorList.n; ++n17) {
                    contributorList.p[n17].weight *= d25;
                }
                break block11;
            }
            contributorList.p = new Contributor[(int)(d16 * 2.0 + 1.0 + 0.5)];
            double d27 = (double)n16 / d15;
            int n26 = (int)Math.ceil(d27 - d16);
            int n27 = (int)Math.floor(d27 + d16);
            for (int i15 = n26; i15 <= n27; ++i15) {
                double d28 = d27 - (double)i15;
                d28 = interpolationFilter.filter(d28);
                int n28 = i15 < 0 ? -i15 : (i15 >= n15 ? n15 - i15 + n15 - 1 : i15);
                if (n28 >= n15) {
                    n28 %= n15;
                } else if (n28 < 0) {
                    n28 = n15 - 1;
                }
                ++contributorList.n;
                contributorList.p[var21_18] = new Contributor();
                contributorList.p[var21_18].pixel = n28;
                contributorList.p[var21_18].weight = d28;
            }
        }
        return contributorList;
    }

    private BufferedImage resample(BufferedImage bufferedImage, BufferedImage bufferedImage2, InterpolationFilter interpolationFilter) {
        int n15;
        int n16;
        double d15;
        int n17;
        int n18 = bufferedImage2.getWidth();
        int n19 = bufferedImage2.getHeight();
        int n25 = bufferedImage.getWidth();
        int n26 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = ImageUtil.createCompatibleWritableRaster(bufferedImage, colorModel, 1, n26);
        double d16 = (double)n18 / (double)n25;
        double d17 = (double)n19 / (double)n26;
        ContributorList[] contributorListArray = new ContributorList[n19];
        for (int i15 = 0; i15 < contributorListArray.length; ++i15) {
            contributorListArray[i15] = new ContributorList();
        }
        double d18 = interpolationFilter.support();
        if (d17 < 1.0) {
            double d19 = d18 / d17;
            double d25 = 1.0 / d17;
            if (d19 <= 0.5) {
                d19 = 0.500001;
                d25 = 1.0;
            }
            for (n17 = 0; n17 < n19; ++n17) {
                int n27;
                contributorListArray[n17].p = new Contributor[(int)(d19 * 2.0 + 1.0 + 0.5)];
                d15 = (double)n17 / d17;
                n16 = (int)Math.ceil(d15 - d19);
                int n28 = (int)Math.floor(d15 + d19);
                double d26 = 0.0;
                for (n27 = n16; n27 <= n28; ++n27) {
                    double d27 = d15 - (double)n27;
                    d27 = interpolationFilter.filter(d27 / d25) / d25;
                    int n29 = n27 < 0 ? -n27 : (n27 >= n26 ? n26 - n27 + n26 - 1 : n27);
                    if (n29 >= n26) {
                        n29 %= n26;
                    } else if (n29 < 0) {
                        n29 = n26 - 1;
                    }
                    ++contributorListArray[n17].n;
                    contributorListArray[n17].p[var32_37] = new Contributor();
                    contributorListArray[n17].p[var32_37].pixel = n29;
                    contributorListArray[n17].p[var32_37].weight = d27;
                    d26 += d27;
                }
                if (d26 == 0.0 || d26 == 1.0) continue;
                d26 = 1.0 / d26;
                for (n27 = 0; n27 < contributorListArray[n17].n; ++n27) {
                    contributorListArray[n17].p[n27].weight *= d26;
                }
            }
        } else {
            for (int i16 = 0; i16 < n19; ++i16) {
                contributorListArray[i16].p = new Contributor[(int)(d18 * 2.0 + 1.0 + 0.5)];
                double d28 = (double)i16 / d17;
                double d29 = Math.ceil(d28 - d18);
                d15 = Math.floor(d28 + d18);
                n16 = (int)d29;
                while ((double)n16 <= d15) {
                    double d35 = d28 - (double)n16;
                    d35 = interpolationFilter.filter(d35);
                    n15 = n16 < 0 ? -n16 : (n16 >= n26 ? n26 - n16 + n26 - 1 : n16);
                    if (n15 >= n26) {
                        n15 %= n26;
                    } else if (n15 < 0) {
                        n15 = n26 - 1;
                    }
                    ++contributorListArray[i16].n;
                    contributorListArray[i16].p[n27] = new Contributor();
                    contributorListArray[i16].p[n27].pixel = n15;
                    contributorListArray[i16].p[n27].weight = d35;
                    ++n16;
                }
            }
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        WritableRaster writableRaster3 = bufferedImage2.getRaster();
        int n35 = writableRaster2.getNumBands();
        int[] nArray = new int[n35];
        for (n17 = 0; n17 < n35; ++n17) {
            nArray[n17] = (1 << bufferedImage.getColorModel().getComponentSize(n17)) - 1;
        }
        for (n17 = 0; n17 < n18; ++n17) {
            int n36;
            double d36;
            int n37;
            ContributorList contributorList = this.calcXContrib(d16, d18, n25, interpolationFilter, n17);
            for (n37 = 0; n37 < n26; ++n37) {
                for (n16 = 0; n16 < n35; ++n16) {
                    double d37 = 0.0;
                    n15 = 0;
                    d36 = writableRaster2.getSample(contributorList.p[0].pixel, n37, n16);
                    for (n36 = 0; n36 < contributorList.n; ++n36) {
                        double d38;
                        double d39 = d38 = n36 == 0 ? d36 : (double)writableRaster2.getSample(contributorList.p[n36].pixel, n37, n16);
                        if (d38 != d36) {
                            n15 = 1;
                        }
                        d37 += d38 * contributorList.p[n36].weight;
                    }
                    double d45 = d37 = n15 != 0 ? (double)ResampleOp.round(d37) : d36;
                    if (d37 < 0.0) {
                        d37 = 0.0;
                    } else if (d37 > (double)nArray[n16]) {
                        d37 = nArray[n16];
                    }
                    writableRaster.setSample(0, n37, n16, d37);
                }
            }
            for (n37 = 0; n37 < n19; ++n37) {
                for (n16 = 0; n16 < n35; ++n16) {
                    double d46 = 0.0;
                    n15 = 0;
                    d36 = writableRaster.getSample(0, contributorListArray[n37].p[0].pixel, n16);
                    for (n36 = 0; n36 < contributorListArray[n37].n; ++n36) {
                        double d47;
                        double d48 = d47 = n36 == 0 ? d36 : (double)writableRaster.getSample(0, contributorListArray[n37].p[n36].pixel, n16);
                        if (d47 != d36) {
                            n15 = 1;
                        }
                        d46 += d47 * contributorListArray[n37].p[n36].weight;
                    }
                    double d49 = d46 = n15 != 0 ? (double)ResampleOp.round(d46) : d36;
                    if (d46 < 0.0) {
                        d46 = 0.0;
                    } else if (d46 > (double)nArray[n16]) {
                        d46 = nArray[n16];
                    }
                    writableRaster3.setSample(n17, n37, n16, d46);
                }
            }
        }
        return bufferedImage2;
    }

    static class ContributorList {
        int n;
        Contributor[] p;

        ContributorList() {
        }
    }

    static class Contributor {
        int pixel;
        double weight;

        Contributor() {
        }
    }

    static class BlackmanSincFilter
    implements InterpolationFilter {
        BlackmanSincFilter() {
        }

        @Override
        public final double filter(double d15) {
            return ResampleOp.blackman(d15 / this.support()) * ResampleOp.sinc(d15);
        }

        @Override
        public final double support() {
            return 4.0;
        }
    }

    static class BlackmanBesselFilter
    implements InterpolationFilter {
        BlackmanBesselFilter() {
        }

        @Override
        public final double filter(double d15) {
            return ResampleOp.blackman(d15 / this.support()) * ResampleOp.bessel(d15);
        }

        @Override
        public final double support() {
            return 3.2383;
        }
    }

    static class HammingFilter
    implements InterpolationFilter {
        HammingFilter() {
        }

        @Override
        public final double filter(double d15) {
            return 0.54 + 0.46 * Math.cos(Math.PI * d15);
        }

        @Override
        public final double support() {
            return 1.0;
        }
    }

    static class HanningFilter
    implements InterpolationFilter {
        HanningFilter() {
        }

        @Override
        public final double filter(double d15) {
            return 0.5 + 0.5 * Math.cos(Math.PI * d15);
        }

        @Override
        public final double support() {
            return 1.0;
        }
    }

    static class GaussianFilter
    implements InterpolationFilter {
        GaussianFilter() {
        }

        @Override
        public final double filter(double d15) {
            return Math.exp(-2.0 * d15 * d15) * Math.sqrt(0.6366197723675814);
        }

        @Override
        public final double support() {
            return 1.25;
        }
    }

    static class CatromFilter
    implements InterpolationFilter {
        CatromFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 1.0) {
                return 0.5 * (2.0 + d15 * d15 * (-5.0 + d15 * 3.0));
            }
            if (d15 < 2.0) {
                return 0.5 * (4.0 + d15 * (-8.0 + d15 * (5.0 - d15)));
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 2.0;
        }
    }

    static class BlacmanFilter
    implements InterpolationFilter {
        BlacmanFilter() {
        }

        @Override
        public final double filter(double d15) {
            return ResampleOp.blackman(d15);
        }

        @Override
        public final double support() {
            return 1.0;
        }
    }

    static class MitchellFilter
    implements InterpolationFilter {
        MitchellFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < -2.0) {
                return 0.0;
            }
            if (d15 < -1.0) {
                return 1.7777777777777777 - d15 * (-3.3333333333333335 - d15 * (2.0 - d15 * -0.3888888888888889));
            }
            if (d15 < 0.0) {
                return 0.8888888888888888 + d15 * d15 * (-2.0 - d15 * 1.1666666666666667);
            }
            if (d15 < 1.0) {
                return 0.8888888888888888 + d15 * d15 * (-2.0 + d15 * 1.1666666666666667);
            }
            if (d15 < 2.0) {
                return 1.7777777777777777 + d15 * (-3.3333333333333335 + d15 * (2.0 + d15 * -0.3888888888888889));
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 2.0;
        }
    }

    static class LanczosFilter
    implements InterpolationFilter {
        LanczosFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 3.0) {
                return ResampleOp.sinc(d15) * ResampleOp.sinc(d15 / 3.0);
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 3.0;
        }
    }

    static class CubicFilter
    implements InterpolationFilter {
        CubicFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 1.0) {
                double d16 = d15 * d15;
                return 0.5 * d16 * d15 - d16 + 0.6666666666666666;
            }
            if (d15 < 2.0) {
                d15 = 2.0 - d15;
                return 0.16666666666666666 * (d15 * d15 * d15);
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 2.0;
        }
    }

    static class QuadraticFilter
    implements InterpolationFilter {
        QuadraticFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 0.5) {
                return 0.75 - d15 * d15;
            }
            if (d15 < 1.5) {
                return 0.5 * ((d15 -= 1.5) * d15);
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 1.5;
        }
    }

    static class TriangleFilter
    implements InterpolationFilter {
        TriangleFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 1.0) {
                return 1.0 - d15;
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 1.0;
        }
    }

    static class BoxFilter
    implements InterpolationFilter {
        private final double mSupport;

        public BoxFilter() {
            this.mSupport = 0.5;
        }

        protected BoxFilter(double d15) {
            this.mSupport = d15;
        }

        @Override
        public final double filter(double d15) {
            if (d15 >= -0.5 && d15 < 0.5) {
                return 1.0;
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return this.mSupport;
        }
    }

    static class PointFilter
    extends BoxFilter {
        public PointFilter() {
            super(0.0);
        }
    }

    static class HermiteFilter
    implements InterpolationFilter {
        HermiteFilter() {
        }

        @Override
        public final double filter(double d15) {
            if (d15 < 0.0) {
                d15 = -d15;
            }
            if (d15 < 1.0) {
                return (2.0 * d15 - 3.0) * d15 * d15 + 1.0;
            }
            return 0.0;
        }

        @Override
        public final double support() {
            return 1.0;
        }
    }

    static interface InterpolationFilter {
        public double filter(double var1);

        public double support();
    }

    static final class Value {
        private final RenderingHints.Key key;
        private final String name;
        private final int type;

        public Value(RenderingHints.Key key, String string, int n15) {
            this.key = key;
            this.name = string;
            this.type = ResampleOp.validateFilterType(n15);
        }

        public boolean isCompatibleKey(Key key) {
            return key == this.key;
        }

        public int getFilterType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Key
    extends RenderingHints.Key {
        static int sIndex = 10000;
        private final String name;

        public Key(String string) {
            super(sIndex++);
            this.name = string;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object instanceof Value && ((Value)object).isCompatibleKey(this);
        }

        public String toString() {
            return this.name;
        }
    }
}

