/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageFactory;
import com.twelvemonkeys.image.CopyDither;
import com.twelvemonkeys.image.DiffusionDither;
import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.image.MonochromeColorModel;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

class IndexImage {
    protected static final int DITHER_MASK = 255;
    public static final int DITHER_DEFAULT = 0;
    public static final int DITHER_NONE = 1;
    public static final int DITHER_DIFFUSION = 2;
    public static final int DITHER_DIFFUSION_ALTSCANS = 3;
    protected static final int COLOR_SELECTION_MASK = 65280;
    public static final int COLOR_SELECTION_DEFAULT = 0;
    public static final int COLOR_SELECTION_FAST = 256;
    public static final int COLOR_SELECTION_QUALITY = 512;
    protected static final int TRANSPARENCY_MASK = 0xFF0000;
    public static final int TRANSPARENCY_DEFAULT = 0;
    public static final int TRANSPARENCY_OPAQUE = 65536;
    public static final int TRANSPARENCY_BITMASK = 131072;
    protected static final int TRANSPARENCY_TRANSLUCENT = 196608;

    private IndexImage() {
    }

    @Deprecated
    public static IndexColorModel getIndexColorModel(Image image, int n15, boolean bl4) {
        return IndexImage.getIndexColorModel(image, n15, bl4 ? 256 : 512);
    }

    public static IndexColorModel getIndexColorModel(Image image, int n15, int n16) throws ImageConversionException {
        IndexColorModel indexColorModel = null;
        RenderedImage renderedImage = null;
        if (image instanceof RenderedImage) {
            renderedImage = (RenderedImage)((Object)image);
            ColorModel colorModel = renderedImage.getColorModel();
            if (colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getMapSize() <= n15) {
                indexColorModel = (IndexColorModel)colorModel;
            }
        } else {
            BufferedImageFactory bufferedImageFactory = new BufferedImageFactory(image);
            ColorModel colorModel = bufferedImageFactory.getColorModel();
            if (colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getMapSize() <= n15) {
                indexColorModel = (IndexColorModel)colorModel;
            } else {
                renderedImage = bufferedImageFactory.getBufferedImage();
            }
        }
        if (indexColorModel == null) {
            indexColorModel = IndexImage.createIndexColorModel(ImageUtil.toBuffered(renderedImage), n15, n16);
        } else if (!(indexColorModel instanceof InverseColorMapIndexColorModel)) {
            indexColorModel = new InverseColorMapIndexColorModel(indexColorModel);
        }
        return indexColorModel;
    }

    private static IndexColorModel createIndexColorModel(BufferedImage bufferedImage, int n15, int n16) {
        int n17;
        int n18;
        Object object;
        Object object2;
        int n19;
        int n25;
        boolean bl4 = IndexImage.isTransparent(n16);
        if (bl4) {
            --n15;
        }
        int n26 = bufferedImage.getWidth();
        int n27 = bufferedImage.getHeight();
        List[] listArray = new List[4096];
        int n28 = 1;
        if (IndexImage.isFast(n16)) {
            n28 += n26 * n27 / 16384;
        }
        int n29 = 0;
        for (n25 = 0; n25 < n26; ++n25) {
            block1: for (n19 = n25 % n28; n19 < n27; n19 += n28) {
                ++n29;
                int n35 = bufferedImage.getRGB(n25, n19) & 0xFFFFFF;
                int n36 = (n35 & 0xF00000) >>> 12 | (n35 & 0xF000) >>> 8 | (n35 & 0xF0) >>> 4;
                object2 = listArray[n36];
                if (object2 == null) {
                    object2 = new ArrayList();
                    object2.add(new Counter(n35));
                    listArray[n36] = object2;
                    continue;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    if (!((Counter)object.next()).add(n35)) continue;
                    continue block1;
                }
                object2.add(new Counter(n35));
            }
        }
        n25 = 1;
        n19 = 0;
        Cube[] cubeArray = new Cube[n15];
        cubeArray[0] = new Cube(listArray, n29);
        while (n25 < n15) {
            while (cubeArray[n19].isDone() && ++n19 != n25) {
            }
            if (n19 == n25) break;
            object2 = cubeArray[n19];
            object = ((Cube)object2).split();
            if (object == null) continue;
            if (((Cube)object).count > ((Cube)object2).count) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            int n37 = n19;
            n18 = ((Cube)object2).count;
            for (n17 = n19 + 1; n17 < n25 && cubeArray[n17].count >= n18; ++n17) {
                cubeArray[n37++] = cubeArray[n17];
            }
            cubeArray[n37++] = object2;
            n18 = ((Cube)object).count;
            while (n37 < n25 && cubeArray[n37].count >= n18) {
                ++n37;
            }
            System.arraycopy(cubeArray, n37, cubeArray, n37 + 1, n25 - n37);
            cubeArray[n37] = object;
            ++n25;
        }
        object2 = new byte[bl4 ? n25 + 1 : n25];
        object = new byte[bl4 ? n25 + 1 : n25];
        byte[] byArray = new byte[bl4 ? n25 + 1 : n25];
        for (n18 = 0; n18 < n25; ++n18) {
            n17 = cubeArray[n18].averageColor();
            object2[n18] = (byte)(n17 >> 16 & 0xFF);
            object[n18] = (byte)(n17 >> 8 & 0xFF);
            byArray[n18] = (byte)(n17 & 0xFF);
        }
        n18 = 8;
        InverseColorMapIndexColorModel inverseColorMapIndexColorModel = bl4 ? new InverseColorMapIndexColorModel(n18, ((Object)object2).length, (byte[])object2, (byte[])object, byArray, ((Object)object2).length - 1) : new InverseColorMapIndexColorModel(n18, ((Object)object2).length, (byte[])object2, (byte[])object, byArray);
        return inverseColorMapIndexColorModel;
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage) {
        return IndexImage.getIndexedImage(bufferedImage, 256, 0);
    }

    private static boolean isFast(int n15) {
        return (n15 & 0xFF00) != 512;
    }

    static boolean isTransparent(int n15) {
        return (n15 & 0x20000) != 0 || (n15 & 0x30000) != 0;
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, Image image, Color color, int n15) throws ImageConversionException {
        return IndexImage.getIndexedImage(bufferedImage, IndexImage.getIndexColorModel(image, 256, n15), color, n15);
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, int n15, Color color, int n16) {
        IndexColorModel indexColorModel = color != null ? IndexImage.getIndexColorModel((Image)IndexImage.createSolid(bufferedImage, color), n15, n16) : IndexImage.getIndexColorModel((Image)bufferedImage, n15, n16);
        if ((n16 & 0xFF) != 1 && indexColorModel.getMapSize() < n15) {
            n16 = n16 & 0xFFFFFF00 | 1;
        }
        return IndexImage.getIndexedImage(bufferedImage, indexColorModel, color, n16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, IndexColorModel indexColorModel, Color color, int n15) {
        int n16 = bufferedImage.getWidth();
        int n17 = bufferedImage.getHeight();
        boolean bl4 = IndexImage.isTransparent(n15) && bufferedImage.getColorModel().getTransparency() != 1 && indexColorModel.getTransparency() != 1;
        BufferedImage bufferedImage2 = bufferedImage;
        if (color != null) {
            bufferedImage2 = IndexImage.createSolid(bufferedImage, color);
        }
        BufferedImage bufferedImage3 = indexColorModel.getMapSize() > 2 ? new BufferedImage(n16, n17, 13, indexColorModel) : new BufferedImage(n16, n17, 12, indexColorModel);
        switch (n15 & 0xFF) {
            case 2: 
            case 3: {
                DiffusionDither diffusionDither = new DiffusionDither(indexColorModel);
                if ((n15 & 0xFF) == 3) {
                    diffusionDither.setAlternateScans(true);
                }
                diffusionDither.filter(bufferedImage2, bufferedImage3);
                break;
            }
            case 1: {
                CopyDither copyDither = new CopyDither(indexColorModel);
                copyDither.filter(bufferedImage2, bufferedImage3);
                break;
            }
            default: {
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                try {
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                    graphics2D.setRenderingHints(renderingHints);
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                    break;
                }
                finally {
                    graphics2D.dispose();
                }
            }
        }
        if (bl4) {
            IndexImage.applyAlpha(bufferedImage3, bufferedImage);
        }
        return bufferedImage3;
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, int n15, int n16) {
        return IndexImage.getIndexedImage(bufferedImage, n15, null, n16);
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, IndexColorModel indexColorModel, int n15) {
        return IndexImage.getIndexedImage(bufferedImage, indexColorModel, null, n15);
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, Image image, int n15) {
        return IndexImage.getIndexedImage(bufferedImage, image, null, n15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createSolid(BufferedImage bufferedImage, Color color) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), bufferedImage.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setColor(color);
            graphics2D.setComposite(AlphaComposite.DstOver);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    private static void applyAlpha(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        for (int i15 = 0; i15 < bufferedImage2.getHeight(); ++i15) {
            for (int i16 = 0; i16 < bufferedImage2.getWidth(); ++i16) {
                if ((bufferedImage2.getRGB(i16, i15) >> 24 & 0xFF) >= 64) continue;
                bufferedImage.setRGB(i16, i15, 0xFFFFFF);
            }
        }
    }

    public static void main(String[] stringArray) {
        IndexColorModel indexColorModel;
        BufferedImage bufferedImage;
        Object object;
        File file2;
        Object object2;
        Object object3;
        int n15 = 0;
        int n16 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n17 = 256;
        String string = null;
        String string2 = null;
        String string3 = null;
        Color color = null;
        boolean bl7 = false;
        String string4 = null;
        boolean bl8 = false;
        while (n15 < stringArray.length && stringArray[n15].charAt(0) == '-' && stringArray[n15].length() >= 2) {
            if (stringArray[n15].charAt(1) == 's' || stringArray[n15].equals("--speedtest")) {
                if (stringArray.length > ++n15 && stringArray[n15].charAt(0) != '-') {
                    try {
                        n16 = Integer.parseInt(stringArray[n15++]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl8 = true;
                        break;
                    }
                }
                n16 = 10;
                continue;
            }
            if (stringArray[n15].charAt(1) == 'w' || stringArray[n15].equals("--overwrite")) {
                bl4 = true;
                ++n15;
                continue;
            }
            if (stringArray[n15].charAt(1) == 'c' || stringArray[n15].equals("--colors")) {
                ++n15;
                try {
                    n17 = Integer.parseInt(stringArray[n15++]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    bl8 = true;
                    break;
                }
            }
            if (stringArray[n15].charAt(1) == 'g' || stringArray[n15].equals("--grayscale")) {
                ++n15;
                bl6 = true;
                continue;
            }
            if (stringArray[n15].charAt(1) == 'm' || stringArray[n15].equals("--monochrome")) {
                ++n15;
                n17 = 2;
                bl5 = true;
                continue;
            }
            if (stringArray[n15].charAt(1) == 'd' || stringArray[n15].equals("--dither")) {
                int n18 = ++n15;
                ++n15;
                string = stringArray[n18];
                continue;
            }
            if (stringArray[n15].charAt(1) == 'p' || stringArray[n15].equals("--palette")) {
                int n19 = ++n15;
                ++n15;
                string4 = stringArray[n19];
                continue;
            }
            if (stringArray[n15].charAt(1) == 'q' || stringArray[n15].equals("--quality")) {
                int n25 = ++n15;
                ++n15;
                string2 = stringArray[n25];
                continue;
            }
            if (stringArray[n15].charAt(1) == 'b' || stringArray[n15].equals("--bgcolor")) {
                ++n15;
                try {
                    color = StringUtil.toColor(stringArray[n15++]);
                    continue;
                }
                catch (Exception exception) {
                    bl8 = true;
                    break;
                }
            }
            if (stringArray[n15].charAt(1) == 't' || stringArray[n15].equals("--transparency")) {
                ++n15;
                bl7 = true;
                continue;
            }
            if (stringArray[n15].charAt(1) == 'f' || stringArray[n15].equals("--outputformat")) {
                int n26 = ++n15;
                ++n15;
                string3 = StringUtil.toLowerCase(stringArray[n26]);
                continue;
            }
            if (stringArray[n15].charAt(1) == 'h' || stringArray[n15].equals("--help")) {
                ++n15;
                bl8 = true;
                continue;
            }
            System.err.println("Unknown option \"" + stringArray[n15++] + "\"");
        }
        if (bl8 || stringArray.length < n15 + 1) {
            System.err.println("Usage: IndexImage [--help|-h] [--speedtest|-s <integer>] [--bgcolor|-b <color>] [--colors|-c <integer> | --grayscale|g | --monochrome|-m | --palette|-p <file>] [--dither|-d (default|diffusion|none)] [--quality|-q (default|high|low)] [--transparency|-t] [--outputformat|-f (gif|jpeg|png|wbmp|...)] [--overwrite|-w] <input> [<output>]");
            System.err.print("Input format names: ");
            object3 = ImageIO.getReaderFormatNames();
            for (int i15 = 0; i15 < ((String[])object3).length; ++i15) {
                System.err.print((String)object3[i15] + (i15 + 1 < ((Object)object3).length ? ", " : "\n"));
            }
            System.err.print("Output format names: ");
            object2 = ImageIO.getWriterFormatNames();
            for (int i16 = 0; i16 < ((String[])object2).length; ++i16) {
                System.err.print((String)object2[i16] + (i16 + 1 < ((Object)object2).length ? ", " : "\n"));
            }
            System.exit(5);
        }
        if (!((File)(object3 = new File(stringArray[n15++]))).exists()) {
            System.err.println("File \"" + ((File)object3).getAbsolutePath() + "\" does not exist!");
            System.exit(5);
        }
        object2 = null;
        if (string4 != null && !((File)(object2 = new File(string4))).exists()) {
            System.err.println("File \"" + ((File)object3).getAbsolutePath() + "\" does not exist!");
            System.exit(5);
        }
        if (n15 < stringArray.length) {
            file2 = new File(stringArray[n15]);
            if (string3 == null) {
                string3 = FileUtil.getExtension(file2);
            }
        } else {
            object = FileUtil.getBasename((File)object3);
            if (string3 == null) {
                string3 = "png";
            }
            file2 = new File((String)object + '.' + string3);
        }
        if (!bl4 && file2.exists()) {
            System.err.println("The file \"" + file2.getAbsolutePath() + "\" allready exists!");
            System.exit(5);
        }
        object = null;
        BufferedImage bufferedImage2 = null;
        try {
            object = ImageIO.read((File)object3);
            if (object == null) {
                System.err.println("No reader for image: \"" + ((File)object3).getAbsolutePath() + "\"!");
                System.exit(5);
            }
            if (object2 != null && (bufferedImage2 = ImageIO.read((File)object2)) == null) {
                System.err.println("No reader for image: \"" + ((File)object2).getAbsolutePath() + "\"!");
                System.exit(5);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(5);
        }
        int n27 = 0;
        if ("DIFFUSION".equalsIgnoreCase(string)) {
            n27 |= 2;
        } else if ("DIFFUSION_ALTSCANS".equalsIgnoreCase(string)) {
            n27 |= 3;
        } else if ("NONE".equalsIgnoreCase(string)) {
            n27 |= 1;
        }
        if ("HIGH".equalsIgnoreCase(string2)) {
            n27 |= 0x200;
        } else if ("LOW".equalsIgnoreCase(string2)) {
            n27 |= 0x100;
        }
        if (bl7) {
            n27 |= 0x20000;
        }
        if (color != null && bufferedImage2 == null) {
            bufferedImage2 = IndexImage.createSolid((BufferedImage)object, color);
        }
        long l15 = 0L;
        if (n16 > 0) {
            System.out.println("Measuring speed!");
            l15 = System.currentTimeMillis();
        }
        if (bl5) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)object, MonochromeColorModel.getInstance(), color, n27);
            indexColorModel = MonochromeColorModel.getInstance();
        } else if (bl6) {
            object = ImageUtil.toBuffered(ImageUtil.grayscale((Image)object));
            indexColorModel = IndexImage.getIndexColorModel((Image)object, n17, n27);
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)object, indexColorModel, color, n27);
            if (n16 > 0) {
                indexColorModel = IndexImage.getIndexColorModel((Image)bufferedImage, n17, n27);
            }
        } else if (bufferedImage2 != null) {
            indexColorModel = IndexImage.getIndexColorModel((Image)bufferedImage2, n17, n27);
            bufferedImage = IndexImage.getIndexedImage(ImageUtil.toBuffered((BufferedImage)object, 2), indexColorModel, color, n27);
        } else {
            object = ImageUtil.toBuffered((BufferedImage)object, 2);
            indexColorModel = IndexImage.getIndexColorModel((Image)object, n17, n27);
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)object, indexColorModel, color, n27);
        }
        if (n16 > 0) {
            System.out.println("Color selection + dither: " + (System.currentTimeMillis() - l15) + " ms");
        }
        try {
            if (!ImageIO.write((RenderedImage)bufferedImage, string3, file2)) {
                System.err.println("No writer for format: \"" + string3 + "\"!");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        if (n16 > 0) {
            System.out.println("Measuring speed!");
            for (int i17 = 0; i17 < 10; ++i17) {
                IndexImage.getIndexedImage((BufferedImage)object, indexColorModel, color, n27);
            }
            long l16 = 0L;
            for (int i18 = 0; i18 < n16; ++i18) {
                l15 = System.currentTimeMillis();
                IndexImage.getIndexedImage((BufferedImage)object, indexColorModel, color, n27);
                l16 += System.currentTimeMillis() - l15;
                System.out.print('.');
                if ((i18 + 1) % 10 != 0) continue;
                System.out.println("\nAverage (after " + (i18 + 1) + " iterations): " + l16 / (long)(i18 + 1) + "ms");
            }
            System.out.println("\nDither only:");
            System.out.println("Total time (" + n16 + " invocations): " + l16 + "ms");
            System.out.println("Average: " + l16 / (long)n16 + "ms");
        }
    }

    private static class Cube {
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        List<Counter>[] colors = null;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        public Cube(List<Counter>[] listArray, int n15) {
            this.colors = listArray;
            this.count = n15;
        }

        public boolean isDone() {
            return this.done;
        }

        public Cube split() {
            int n15;
            int n16;
            int n17;
            int n18 = this.max[0] - this.min[0] + 1;
            int n19 = this.max[1] - this.min[1] + 1;
            int n25 = this.max[2] - this.min[2] + 1;
            if (n18 >= n19) {
                n17 = 1;
                if (n18 >= n25) {
                    n16 = 0;
                    n15 = 2;
                } else {
                    n16 = 2;
                    n15 = 0;
                }
            } else if (n19 >= n25) {
                n16 = 1;
                n17 = 0;
                n15 = 2;
            } else {
                n16 = 2;
                n17 = 0;
                n15 = 1;
            }
            Cube cube = this.splitChannel(n16, n17, n15);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n17, n16, n15);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n15, n16, n17);
            if (cube != null) {
                return cube;
            }
            this.done = true;
            return null;
        }

        public Cube splitChannel(int n15, int n16, int n17) {
            int n18;
            int n19;
            int n25;
            int n26;
            int n27;
            if (this.min[n15] == this.max[n15]) {
                return null;
            }
            int n28 = (2 - n15) * 4;
            int n29 = (2 - n16) * 4;
            int n35 = (2 - n17) * 4;
            int n36 = this.count / 2;
            int[] nArray = new int[256];
            int n37 = 0;
            int[] nArray2 = new int[]{this.min[0] >> 4, this.min[1] >> 4, this.min[2] >> 4};
            int[] nArray3 = new int[]{this.max[0] >> 4, this.max[1] >> 4, this.max[2] >> 4};
            int n38 = this.min[0];
            int n39 = this.min[1];
            int n45 = this.min[2];
            int n46 = this.max[0];
            int n47 = this.max[1];
            int n48 = this.max[2];
            int[] nArray4 = new int[]{0, 0, 0};
            for (n27 = nArray2[n15]; n27 <= nArray3[n15]; ++n27) {
                n26 = n27 << n28;
                for (n25 = nArray2[n16]; n25 <= nArray3[n16]; ++n25) {
                    n19 = n26 | n25 << n29;
                    for (n18 = nArray2[n17]; n18 <= nArray3[n17]; ++n18) {
                        int n49 = n19 | n18 << n35;
                        List<Counter> list2 = this.colors[n49];
                        if (list2 == null) continue;
                        for (Counter counter : list2) {
                            int n55 = counter.val;
                            nArray4[0] = (n55 & 0xFF0000) >> 16;
                            nArray4[1] = (n55 & 0xFF00) >> 8;
                            nArray4[2] = n55 & 0xFF;
                            if (nArray4[0] < n38 || nArray4[0] > n46 || nArray4[1] < n39 || nArray4[1] > n47 || nArray4[2] < n45 || nArray4[2] > n48) continue;
                            int n56 = nArray4[n15];
                            nArray[n56] = nArray[n56] + counter.count;
                            n37 += counter.count;
                        }
                    }
                }
                if (n37 >= n36) break;
            }
            n37 = 0;
            n27 = -1;
            n26 = this.min[n15];
            n25 = this.max[n15];
            for (n19 = this.min[n15]; n19 <= this.max[n15]; ++n19) {
                n18 = nArray[n19];
                if (n18 == 0) {
                    if (n37 != 0 || n19 >= this.max[n15]) continue;
                    this.min[n15] = n19 + 1;
                    continue;
                }
                if (n37 + n18 < n36) {
                    n27 = n19;
                    n37 += n18;
                    continue;
                }
                if (n36 - n37 <= n37 + n18 - n36) {
                    if (n27 == -1) {
                        if (n18 == this.count) {
                            this.max[n15] = n19;
                            return null;
                        }
                        n26 = n19;
                        n25 = n19 + 1;
                        break;
                    }
                    n26 = n27;
                    n25 = n19;
                    break;
                }
                if (n19 == this.max[n15]) {
                    if (n18 == this.count) {
                        return null;
                    }
                    n26 = n27;
                    n25 = n19;
                    break;
                }
                n37 += n18;
                n26 = n19;
                n25 = n19 + 1;
                break;
            }
            Cube cube = new Cube(this.colors, n37);
            this.count -= n37;
            cube.min[n15] = this.min[n15];
            cube.max[n15] = n26;
            this.min[n15] = n25;
            cube.min[n16] = this.min[n16];
            cube.max[n16] = this.max[n16];
            cube.min[n17] = this.min[n17];
            cube.max[n17] = this.max[n17];
            return cube;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            int n15 = this.min[0];
            int n16 = this.min[1];
            int n17 = this.min[2];
            int n18 = this.max[0];
            int n19 = this.max[1];
            int n25 = this.max[2];
            int[] nArray = new int[]{n15 >> 4, n16 >> 4, n17 >> 4};
            int[] nArray2 = new int[]{n18 >> 4, n19 >> 4, n25 >> 4};
            for (int i15 = nArray[0]; i15 <= nArray2[0]; ++i15) {
                int n26 = i15 << 8;
                for (int i16 = nArray[1]; i16 <= nArray2[1]; ++i16) {
                    int n27 = n26 | i16 << 4;
                    for (int i17 = nArray[2]; i17 <= nArray2[2]; ++i17) {
                        int n28 = n27 | i17;
                        List<Counter> list2 = this.colors[n28];
                        if (list2 == null) continue;
                        for (Counter counter : list2) {
                            int n29 = counter.val;
                            int n35 = (n29 & 0xFF0000) >> 16;
                            int n36 = (n29 & 0xFF00) >> 8;
                            int n37 = n29 & 0xFF;
                            if (n35 < n15 || n35 > n18 || n36 < n16 || n36 > n19 || n37 < n17 || n37 > n25) continue;
                            float f18 = (float)counter.count / (float)this.count;
                            f15 += (float)n35 * f18;
                            f16 += (float)n36 * f18;
                            f17 += (float)n37 * f18;
                        }
                    }
                }
            }
            return (int)(f15 + 0.5f) << 16 | (int)(f16 + 0.5f) << 8 | (int)(f17 + 0.5f);
        }
    }

    private static class Counter {
        public int val;
        public int count = 1;

        public Counter(int n15) {
            this.val = n15;
        }

        public boolean add(int n15) {
            if (this.val != n15) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

