/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field f15) {
            return f15.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field f15) {
            return 2.upperCaseFirstLetter(f15.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field f15) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(f15.getName(), ' '));
        }
    }
    ,
    UPPER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f15) {
            return 4.separateCamelCase(f15.getName(), '_').toUpperCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f15) {
            return 5.separateCamelCase(f15.getName(), '_').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field f15) {
            return 6.separateCamelCase(f15.getName(), '-').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public String translateName(Field f15) {
            return 7.separateCamelCase(f15.getName(), '.').toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String name, char separator) {
        StringBuilder translation = new StringBuilder();
        int length = name.length();
        for (int i15 = 0; i15 < length; ++i15) {
            char character = name.charAt(i15);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append(separator);
            }
            translation.append(character);
        }
        return translation.toString();
    }

    static String upperCaseFirstLetter(String s15) {
        int length = s15.length();
        for (int i15 = 0; i15 < length; ++i15) {
            char c15 = s15.charAt(i15);
            if (!Character.isLetter(c15)) continue;
            if (Character.isUpperCase(c15)) {
                return s15;
            }
            char uppercased = Character.toUpperCase(c15);
            if (i15 == 0) {
                return uppercased + s15.substring(1);
            }
            return s15.substring(0, i15) + uppercased + s15.substring(i15 + 1);
        }
        return s15;
    }
}

