/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.InlineMe;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = -889275714L;

    public static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return CollectCollectors.toImmutableList();
    }

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY;
    }

    public static <E> ImmutableList<E> of(E e15) {
        return new SingletonImmutableList<E>(e15);
    }

    public static <E> ImmutableList<E> of(E e15, E e25) {
        return ImmutableList.construct(e15, e25);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35) {
        return ImmutableList.construct(e15, e25, e35);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45) {
        return ImmutableList.construct(e15, e25, e35, e45);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55) {
        return ImmutableList.construct(e15, e25, e35, e45, e55);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65, e75);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75, E e85) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65, e75, e85);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75, E e85, E e95) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65, e75, e85, e95);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75, E e85, E e95, E e102) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65, e75, e85, e95, e102);
    }

    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75, E e85, E e95, E e102, E e112) {
        return ImmutableList.construct(e15, e25, e35, e45, e55, e65, e75, e85, e95, e102, e112);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> of(E e15, E e25, E e35, E e45, E e55, E e65, E e75, E e85, E e95, E e102, E e112, E e122, E ... others) {
        Preconditions.checkArgument(others.length <= 0x7FFFFFF3, "the total number of elements must fit in an int");
        Object[] array = new Object[12 + others.length];
        array[0] = e15;
        array[1] = e25;
        array[2] = e35;
        array[3] = e45;
        array[4] = e55;
        array[5] = e65;
        array[6] = e75;
        array[7] = e85;
        array[8] = e95;
        array[9] = e102;
        array[10] = e112;
        array[11] = e122;
        System.arraycopy(others, 0, array, 12, others.length);
        return ImmutableList.construct(array);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        return elements instanceof Collection ? ImmutableList.copyOf((Collection)elements) : ImmutableList.copyOf(elements.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableCollection) {
            ImmutableList list2 = ((ImmutableCollection)elements).asList();
            return list2.isPartialView() ? ImmutableList.asImmutableList(list2.toArray()) : list2;
        }
        return ImmutableList.construct(elements.toArray());
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> elements) {
        if (!elements.hasNext()) {
            return ImmutableList.of();
        }
        E first = elements.next();
        if (!elements.hasNext()) {
            return ImmutableList.of(first);
        }
        return ((Builder)((Builder)new Builder().add((Object)first)).addAll(elements)).build();
    }

    public static <E> ImmutableList<E> copyOf(E[] elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(elements[0]);
            }
        }
        return ImmutableList.construct((Object[])elements.clone());
    }

    public static <E extends Comparable<? super E>> ImmutableList<E> sortedCopyOf(Iterable<? extends E> elements) {
        Object[] array = Iterables.toArray(elements, new Comparable[0]);
        ObjectArrays.checkElementsNotNull(array);
        Arrays.sort(array);
        return ImmutableList.asImmutableList(array);
    }

    public static <E> ImmutableList<E> sortedCopyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        Preconditions.checkNotNull(comparator);
        Object[] array = Iterables.toArray(elements);
        ObjectArrays.checkElementsNotNull(array);
        Arrays.sort(array, comparator);
        return ImmutableList.asImmutableList(array);
    }

    private static <E> ImmutableList<E> construct(Object ... elements) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(elements));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        return ImmutableList.asImmutableList(elements, elements.length);
    }

    static <E> ImmutableList<E> asImmutableList(@Nullable Object[] elements, int length) {
        switch (length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                Object onlyElement = Objects.requireNonNull(elements[0]);
                return ImmutableList.of(onlyElement);
            }
        }
        Object[] elementsWithoutTrailingNulls = length < elements.length ? Arrays.copyOf(elements, length) : elements;
        return new RegularImmutableList(elementsWithoutTrailingNulls);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return new AbstractIndexedListIterator<E>(this.size(), index){

            @Override
            protected E get(int index) {
                return ImmutableList.this.get(index);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n15 = this.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            consumer.accept(this.get(i15));
        }
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.indexOfImpl(this, object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.lastIndexOfImpl(this, object);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        int length = toIndex - fromIndex;
        if (length == this.size()) {
            return this;
        }
        if (length == 0) {
            return ImmutableList.of();
        }
        if (length == 1) {
            return ImmutableList.of(this.get(fromIndex));
        }
        return this.subListUnchecked(fromIndex, toIndex);
    }

    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new SubList(fromIndex, toIndex - fromIndex);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void sort(@Nullable Comparator<? super E> c15) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @InlineMe(replacement="this")
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1296, this::get);
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        int size = this.size();
        for (int i15 = 0; i15 < size; ++i15) {
            dst[offset + i15] = this.get(i15);
        }
        return offset + size;
    }

    public ImmutableList<E> reverse() {
        return this.size() <= 1 ? this : new ReverseImmutableList(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return Lists.equalsImpl(this, obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int n15 = this.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            hashCode = 31 * hashCode + this.get(i15).hashCode();
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(expectedSize);
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        @VisibleForTesting
        @Nullable Object[] contents;
        private int size;
        private boolean copyOnWrite;

        public Builder() {
            this(4);
        }

        Builder(int capacity) {
            this.contents = new Object[capacity];
            this.size = 0;
        }

        private void ensureRoomFor(int newElements) {
            @Nullable Object[] contents = this.contents;
            int newCapacity = Builder.expandedCapacity(contents.length, this.size + newElements);
            if (contents.length < newCapacity || this.copyOnWrite) {
                this.contents = Arrays.copyOf(contents, newCapacity);
                this.copyOnWrite = false;
            }
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element);
            this.ensureRoomFor(1);
            this.contents[this.size++] = element;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            ObjectArrays.checkElementsNotNull((Object[])elements);
            this.add((Object[])elements, elements.length);
            return this;
        }

        private void add(@Nullable Object[] elements, int n15) {
            this.ensureRoomFor(n15);
            System.arraycopy(elements, 0, this.contents, this.size, n15);
            this.size += n15;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            Preconditions.checkNotNull(elements);
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                this.ensureRoomFor(collection.size());
                if (collection instanceof ImmutableCollection) {
                    ImmutableCollection immutableCollection = (ImmutableCollection)collection;
                    this.size = immutableCollection.copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        Builder<E> combine(Builder<E> builder) {
            Preconditions.checkNotNull(builder);
            this.add(builder.contents, builder.size);
            return this;
        }

        @Override
        public ImmutableList<E> build() {
            this.copyOnWrite = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }

        ImmutableList<E> buildSorted(Comparator<? super E> comparator) {
            this.copyOnWrite = true;
            Arrays.sort(this.contents, 0, this.size, comparator);
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    private final class SubList
    extends ImmutableList<E> {
        final transient int offset;
        final transient int length;

        SubList(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public E get(int index) {
            Preconditions.checkElementIndex(index, this.length);
            return ImmutableList.this.get(index + this.offset);
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.length);
            return ImmutableList.this.subList(fromIndex + this.offset, toIndex + this.offset);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    private static final class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        ReverseImmutableList(ImmutableList<E> backingList) {
            this.forwardList = backingList;
        }

        private int reverseIndex(int index) {
            return this.size() - 1 - index;
        }

        private int reversePosition(int index) {
            return this.size() - index;
        }

        @Override
        public ImmutableList<E> reverse() {
            return this.forwardList;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public int indexOf(@Nullable Object object) {
            int index = this.forwardList.lastIndexOf(object);
            return index >= 0 ? this.reverseIndex(index) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            int index = this.forwardList.indexOf(object);
            return index >= 0 ? this.reverseIndex(index) : -1;
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return ((ImmutableList)this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex))).reverse();
        }

        @Override
        public E get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.forwardList.get(this.reverseIndex(index));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        boolean isPartialView() {
            return this.forwardList.isPartialView();
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }

    @J2ktIncompatible
    static final class SerializedForm
    implements Serializable {
        final Object[] elements;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }
}

